package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TrafficPolicyPortTrafficPolicyFluent<A extends TrafficPolicyPortTrafficPolicyFluent<A>> extends BaseFluent<A>{
  public TrafficPolicyPortTrafficPolicyFluent() {
  }
  public TrafficPolicyPortTrafficPolicyFluent(TrafficPolicyPortTrafficPolicy instance) {
    instance = (instance != null ? instance : new TrafficPolicyPortTrafficPolicy());

    if (instance != null) {
      this.withConnectionPool(instance.getConnectionPool());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOutlierDetection(instance.getOutlierDetection());
      this.withPort(instance.getPort());
      this.withTls(instance.getTls());
      this.withConnectionPool(instance.getConnectionPool());
      this.withLoadBalancer(instance.getLoadBalancer());
      this.withOutlierDetection(instance.getOutlierDetection());
      this.withPort(instance.getPort());
      this.withTls(instance.getTls());
    }
  }
  private ConnectionPoolSettingsBuilder connectionPool;
  private LoadBalancerSettingsBuilder loadBalancer;
  private OutlierDetectionBuilder outlierDetection;
  private PortSelectorBuilder port;
  private ClientTLSSettingsBuilder tls;
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    _visitables.get("connectionPool").remove(this.connectionPool);
    if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} else { this.connectionPool = null; _visitables.get("connectionPool").remove(this.connectionPool); } return (A) this;
  }
  public boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  public ConnectionPoolNested<A> withNewConnectionPool() {
    return new ConnectionPoolNested(null);
  }
  public ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new ConnectionPoolNested(item);
  }
  public ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(null));
  }
  public ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
  }
  public ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(item));
  }
  public LoadBalancerSettings buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  public boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public LoadBalancerNested<A> withNewLoadBalancer() {
    return new LoadBalancerNested(null);
  }
  public LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
    return new LoadBalancerNested(item);
  }
  public LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(null));
  }
  public LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(new LoadBalancerSettingsBuilder().build()));
  }
  public LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
    return withNewLoadBalancerLike(java.util.Optional.ofNullable(buildLoadBalancer()).orElse(item));
  }
  public OutlierDetection buildOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public A withOutlierDetection(OutlierDetection outlierDetection) {
    _visitables.get("outlierDetection").remove(this.outlierDetection);
    if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} else { this.outlierDetection = null; _visitables.get("outlierDetection").remove(this.outlierDetection); } return (A) this;
  }
  public boolean hasOutlierDetection() {
    return this.outlierDetection != null;
  }
  public OutlierDetectionNested<A> withNewOutlierDetection() {
    return new OutlierDetectionNested(null);
  }
  public OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
    return new OutlierDetectionNested(item);
  }
  public OutlierDetectionNested<A> editOutlierDetection() {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(null));
  }
  public OutlierDetectionNested<A> editOrNewOutlierDetection() {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(new OutlierDetectionBuilder().build()));
  }
  public OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
    return withNewOutlierDetectionLike(java.util.Optional.ofNullable(buildOutlierDetection()).orElse(item));
  }
  public PortSelector buildPort() {
    return this.port!=null ?this.port.build():null;
  }
  public A withPort(PortSelector port) {
    _visitables.get("port").remove(this.port);
    if (port!=null){ this.port= new PortSelectorBuilder(port); _visitables.get("port").add(this.port);} else { this.port = null; _visitables.get("port").remove(this.port); } return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public A withNewPort(Integer number) {
    return (A)withPort(new PortSelector(number));
  }
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  public PortNested<A> withNewPortLike(PortSelector item) {
    return new PortNested(item);
  }
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new PortSelectorBuilder().build()));
  }
  public PortNested<A> editOrNewPortLike(PortSelector item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  public ClientTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public boolean hasTls() {
    return this.tls != null;
  }
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  public TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
    return new TlsNested(item);
  }
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ClientTLSSettingsBuilder().build()));
  }
  public TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrafficPolicyPortTrafficPolicyFluent that = (TrafficPolicyPortTrafficPolicyFluent) o;
    if (!java.util.Objects.equals(connectionPool, that.connectionPool)) return false;

    if (!java.util.Objects.equals(loadBalancer, that.loadBalancer)) return false;

    if (!java.util.Objects.equals(outlierDetection, that.outlierDetection)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(tls, that.tls)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionPool,  loadBalancer,  outlierDetection,  port,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (outlierDetection != null) { sb.append("outlierDetection:"); sb.append(outlierDetection + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  public class ConnectionPoolNested<N> extends ConnectionPoolSettingsFluent<ConnectionPoolNested<N>> implements Nested<N>{
    ConnectionPoolNested(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluent.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool() {
      return and();
    }
    
  }
  public class LoadBalancerNested<N> extends LoadBalancerSettingsFluent<LoadBalancerNested<N>> implements Nested<N>{
    LoadBalancerNested(LoadBalancerSettings item) {
      this.builder = new LoadBalancerSettingsBuilder(this, item);
    }
    LoadBalancerSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluent.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer() {
      return and();
    }
    
  }
  public class OutlierDetectionNested<N> extends OutlierDetectionFluent<OutlierDetectionNested<N>> implements Nested<N>{
    OutlierDetectionNested(OutlierDetection item) {
      this.builder = new OutlierDetectionBuilder(this, item);
    }
    OutlierDetectionBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluent.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection() {
      return and();
    }
    
  }
  public class PortNested<N> extends PortSelectorFluent<PortNested<N>> implements Nested<N>{
    PortNested(PortSelector item) {
      this.builder = new PortSelectorBuilder(this, item);
    }
    PortSelectorBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluent.this.withPort(builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  public class TlsNested<N> extends ClientTLSSettingsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ClientTLSSettings item) {
      this.builder = new ClientTLSSettingsBuilder(this, item);
    }
    ClientTLSSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyPortTrafficPolicyFluent.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}