package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TLSMatchAttributesFluent<A extends TLSMatchAttributesFluent<A>> extends BaseFluent<A>{
  public TLSMatchAttributesFluent() {
  }
  public TLSMatchAttributesFluent(TLSMatchAttributes instance) {
    instance = (instance != null ? instance : new TLSMatchAttributes());

    if (instance != null) {
      this.withDestinationSubnets(instance.getDestinationSubnets());
      this.withGateways(instance.getGateways());
      this.withPort(instance.getPort());
      this.withSniHosts(instance.getSniHosts());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
      this.withDestinationSubnets(instance.getDestinationSubnets());
      this.withGateways(instance.getGateways());
      this.withPort(instance.getPort());
      this.withSniHosts(instance.getSniHosts());
      this.withSourceLabels(instance.getSourceLabels());
      this.withSourceNamespace(instance.getSourceNamespace());
    }
  }
  private List<String> destinationSubnets = new ArrayList<String>();
  private List<String> gateways = new ArrayList<String>();
  private Integer port;
  private List<String> sniHosts = new ArrayList<String>();
  private Map<String,String> sourceLabels;
  private String sourceNamespace;
  public A addToDestinationSubnets(int index,String item) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    this.destinationSubnets.add(index, item);
    return (A)this;
  }
  public A setToDestinationSubnets(int index,String item) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    this.destinationSubnets.set(index, item); return (A)this;
  }
  public A addToDestinationSubnets(java.lang.String... items) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
  }
  public A addAllToDestinationSubnets(Collection<String> items) {
    if (this.destinationSubnets == null) {this.destinationSubnets = new ArrayList<String>();}
    for (String item : items) {this.destinationSubnets.add(item);} return (A)this;
  }
  public A removeFromDestinationSubnets(java.lang.String... items) {
    if (this.destinationSubnets == null) return (A)this;
    for (String item : items) { this.destinationSubnets.remove(item);} return (A)this;
  }
  public A removeAllFromDestinationSubnets(Collection<String> items) {
    if (this.destinationSubnets == null) return (A)this;
    for (String item : items) { this.destinationSubnets.remove(item);} return (A)this;
  }
  public List<String> getDestinationSubnets() {
    return this.destinationSubnets;
  }
  public String getDestinationSubnet(int index) {
    return this.destinationSubnets.get(index);
  }
  public String getFirstDestinationSubnet() {
    return this.destinationSubnets.get(0);
  }
  public String getLastDestinationSubnet() {
    return this.destinationSubnets.get(destinationSubnets.size() - 1);
  }
  public String getMatchingDestinationSubnet(Predicate<String> predicate) {
    for (String item: destinationSubnets) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingDestinationSubnet(Predicate<String> predicate) {
    for (String item: destinationSubnets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDestinationSubnets(List<String> destinationSubnets) {
    if (destinationSubnets != null) {this.destinationSubnets = new ArrayList(); for (String item : destinationSubnets){this.addToDestinationSubnets(item);}} else { this.destinationSubnets = null;} return (A) this;
  }
  public A withDestinationSubnets(java.lang.String... destinationSubnets) {
    if (this.destinationSubnets != null) {this.destinationSubnets.clear(); _visitables.remove("destinationSubnets"); }
    if (destinationSubnets != null) {for (String item :destinationSubnets){ this.addToDestinationSubnets(item);}} return (A) this;
  }
  public boolean hasDestinationSubnets() {
    return destinationSubnets != null && !destinationSubnets.isEmpty();
  }
  public A addToGateways(int index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.add(index, item);
    return (A)this;
  }
  public A setToGateways(int index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.set(index, item); return (A)this;
  }
  public A addToGateways(java.lang.String... items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A addAllToGateways(Collection<String> items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A removeFromGateways(java.lang.String... items) {
    if (this.gateways == null) return (A)this;
    for (String item : items) { this.gateways.remove(item);} return (A)this;
  }
  public A removeAllFromGateways(Collection<String> items) {
    if (this.gateways == null) return (A)this;
    for (String item : items) { this.gateways.remove(item);} return (A)this;
  }
  public List<String> getGateways() {
    return this.gateways;
  }
  public String getGateway(int index) {
    return this.gateways.get(index);
  }
  public String getFirstGateway() {
    return this.gateways.get(0);
  }
  public String getLastGateway() {
    return this.gateways.get(gateways.size() - 1);
  }
  public String getMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGateways(List<String> gateways) {
    if (gateways != null) {this.gateways = new ArrayList(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
  }
  public A withGateways(java.lang.String... gateways) {
    if (this.gateways != null) {this.gateways.clear(); _visitables.remove("gateways"); }
    if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
  }
  public boolean hasGateways() {
    return gateways != null && !gateways.isEmpty();
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public boolean hasPort() {
    return this.port != null;
  }
  public A addToSniHosts(int index,String item) {
    if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
    this.sniHosts.add(index, item);
    return (A)this;
  }
  public A setToSniHosts(int index,String item) {
    if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
    this.sniHosts.set(index, item); return (A)this;
  }
  public A addToSniHosts(java.lang.String... items) {
    if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
    for (String item : items) {this.sniHosts.add(item);} return (A)this;
  }
  public A addAllToSniHosts(Collection<String> items) {
    if (this.sniHosts == null) {this.sniHosts = new ArrayList<String>();}
    for (String item : items) {this.sniHosts.add(item);} return (A)this;
  }
  public A removeFromSniHosts(java.lang.String... items) {
    if (this.sniHosts == null) return (A)this;
    for (String item : items) { this.sniHosts.remove(item);} return (A)this;
  }
  public A removeAllFromSniHosts(Collection<String> items) {
    if (this.sniHosts == null) return (A)this;
    for (String item : items) { this.sniHosts.remove(item);} return (A)this;
  }
  public List<String> getSniHosts() {
    return this.sniHosts;
  }
  public String getSniHost(int index) {
    return this.sniHosts.get(index);
  }
  public String getFirstSniHost() {
    return this.sniHosts.get(0);
  }
  public String getLastSniHost() {
    return this.sniHosts.get(sniHosts.size() - 1);
  }
  public String getMatchingSniHost(Predicate<String> predicate) {
    for (String item: sniHosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingSniHost(Predicate<String> predicate) {
    for (String item: sniHosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSniHosts(List<String> sniHosts) {
    if (sniHosts != null) {this.sniHosts = new ArrayList(); for (String item : sniHosts){this.addToSniHosts(item);}} else { this.sniHosts = null;} return (A) this;
  }
  public A withSniHosts(java.lang.String... sniHosts) {
    if (this.sniHosts != null) {this.sniHosts.clear(); _visitables.remove("sniHosts"); }
    if (sniHosts != null) {for (String item :sniHosts){ this.addToSniHosts(item);}} return (A) this;
  }
  public boolean hasSniHosts() {
    return sniHosts != null && !sniHosts.isEmpty();
  }
  public A addToSourceLabels(String key,String value) {
    if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
  }
  public A addToSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap(); }
    if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
  }
  public A removeFromSourceLabels(String key) {
    if(this.sourceLabels == null) { return (A) this; }
    if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
  }
  public A removeFromSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSourceLabels() {
    return this.sourceLabels;
  }
  public <K,V>A withSourceLabels(Map<String,String> sourceLabels) {
    if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap(sourceLabels);} return (A) this;
  }
  public boolean hasSourceLabels() {
    return this.sourceLabels != null;
  }
  public String getSourceNamespace() {
    return this.sourceNamespace;
  }
  public A withSourceNamespace(String sourceNamespace) {
    this.sourceNamespace=sourceNamespace; return (A) this;
  }
  public boolean hasSourceNamespace() {
    return this.sourceNamespace != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TLSMatchAttributesFluent that = (TLSMatchAttributesFluent) o;
    if (!java.util.Objects.equals(destinationSubnets, that.destinationSubnets)) return false;

    if (!java.util.Objects.equals(gateways, that.gateways)) return false;

    if (!java.util.Objects.equals(port, that.port)) return false;

    if (!java.util.Objects.equals(sniHosts, that.sniHosts)) return false;

    if (!java.util.Objects.equals(sourceLabels, that.sourceLabels)) return false;

    if (!java.util.Objects.equals(sourceNamespace, that.sourceNamespace)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(destinationSubnets,  gateways,  port,  sniHosts,  sourceLabels,  sourceNamespace,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destinationSubnets != null && !destinationSubnets.isEmpty()) { sb.append("destinationSubnets:"); sb.append(destinationSubnets + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (sniHosts != null && !sniHosts.isEmpty()) { sb.append("sniHosts:"); sb.append(sniHosts + ","); }
    if (sourceLabels != null && !sourceLabels.isEmpty()) { sb.append("sourceLabels:"); sb.append(sourceLabels + ","); }
    if (sourceNamespace != null) { sb.append("sourceNamespace:"); sb.append(sourceNamespace); }
    sb.append("}");
    return sb.toString();
  }
  
}