package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TCPHealthCheckConfigBuilder extends TCPHealthCheckConfigFluent<TCPHealthCheckConfigBuilder> implements VisitableBuilder<TCPHealthCheckConfig,TCPHealthCheckConfigBuilder>{
  public TCPHealthCheckConfigBuilder() {
    this(false);
  }
  public TCPHealthCheckConfigBuilder(Boolean validationEnabled) {
    this(new TCPHealthCheckConfig(), validationEnabled);
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TCPHealthCheckConfig(), validationEnabled);
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent,TCPHealthCheckConfig instance) {
    this(fluent, instance, false);
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfigFluent<?> fluent,TCPHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TCPHealthCheckConfig());

    if (instance != null) {
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
      fluent.withHost(instance.getHost());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfig instance) {
    this(instance,false);
  }
  public TCPHealthCheckConfigBuilder(TCPHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TCPHealthCheckConfig());

    if (instance != null) {
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
      this.withHost(instance.getHost());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  TCPHealthCheckConfigFluent<?> fluent;
  Boolean validationEnabled;
  public TCPHealthCheckConfig build() {
    TCPHealthCheckConfig buildable = new TCPHealthCheckConfig(fluent.getHost(),fluent.getPort());
    return buildable;
  }
  
}