package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEntryListBuilder extends ServiceEntryListFluent<ServiceEntryListBuilder> implements VisitableBuilder<ServiceEntryList,ServiceEntryListBuilder>{
  public ServiceEntryListBuilder() {
    this(false);
  }
  public ServiceEntryListBuilder(Boolean validationEnabled) {
    this(new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance) {
    this(fluent, instance, false);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ServiceEntryList());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEntryListBuilder(ServiceEntryList instance) {
    this(instance,false);
  }
  public ServiceEntryListBuilder(ServiceEntryList instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ServiceEntryList());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
    }
    this.validationEnabled = validationEnabled; 
  }
  ServiceEntryListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceEntryList build() {
    ServiceEntryList buildable = new ServiceEntryList(fluent.getApiVersion(),fluent.buildItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}