package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessProbeHttpGetBuilder extends ReadinessProbeHttpGetFluent<ReadinessProbeHttpGetBuilder> implements VisitableBuilder<ReadinessProbeHttpGet,ReadinessProbeHttpGetBuilder>{
  public ReadinessProbeHttpGetBuilder() {
    this(false);
  }
  public ReadinessProbeHttpGetBuilder(Boolean validationEnabled) {
    this(new ReadinessProbeHttpGet(), validationEnabled);
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGetFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGetFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessProbeHttpGet(), validationEnabled);
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGetFluent<?> fluent,ReadinessProbeHttpGet instance) {
    this(fluent, instance, false);
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGetFluent<?> fluent,ReadinessProbeHttpGet instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ReadinessProbeHttpGet());

    if (instance != null) {
      fluent.withHttpGet(instance.getHttpGet());
      fluent.withHttpGet(instance.getHttpGet());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGet instance) {
    this(instance,false);
  }
  public ReadinessProbeHttpGetBuilder(ReadinessProbeHttpGet instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ReadinessProbeHttpGet());

    if (instance != null) {
      this.withHttpGet(instance.getHttpGet());
      this.withHttpGet(instance.getHttpGet());
    }
    this.validationEnabled = validationEnabled; 
  }
  ReadinessProbeHttpGetFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessProbeHttpGet build() {
    ReadinessProbeHttpGet buildable = new ReadinessProbeHttpGet(fluent.buildHttpGet());
    return buildable;
  }
  
}