package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRouteDestinationBuilder extends HTTPRouteDestinationFluent<HTTPRouteDestinationBuilder> implements VisitableBuilder<HTTPRouteDestination,HTTPRouteDestinationBuilder>{
  public HTTPRouteDestinationBuilder() {
    this(false);
  }
  public HTTPRouteDestinationBuilder(Boolean validationEnabled) {
    this(new HTTPRouteDestination(), validationEnabled);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRouteDestination(), validationEnabled);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,HTTPRouteDestination instance) {
    this(fluent, instance, false);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestinationFluent<?> fluent,HTTPRouteDestination instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HTTPRouteDestination());

    if (instance != null) {
      fluent.withDestination(instance.getDestination());
      fluent.withHeaders(instance.getHeaders());
      fluent.withWeight(instance.getWeight());
      fluent.withDestination(instance.getDestination());
      fluent.withHeaders(instance.getHeaders());
      fluent.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestination instance) {
    this(instance,false);
  }
  public HTTPRouteDestinationBuilder(HTTPRouteDestination instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HTTPRouteDestination());

    if (instance != null) {
      this.withDestination(instance.getDestination());
      this.withHeaders(instance.getHeaders());
      this.withWeight(instance.getWeight());
      this.withDestination(instance.getDestination());
      this.withHeaders(instance.getHeaders());
      this.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPRouteDestinationFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRouteDestination build() {
    HTTPRouteDestination buildable = new HTTPRouteDestination(fluent.buildDestination(),fluent.buildHeaders(),fluent.getWeight());
    return buildable;
  }
  
}