package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterListenerMatchBuilder extends EnvoyFilterListenerMatchFluent<EnvoyFilterListenerMatchBuilder> implements VisitableBuilder<EnvoyFilterListenerMatch,EnvoyFilterListenerMatchBuilder>{
  public EnvoyFilterListenerMatchBuilder() {
    this(false);
  }
  public EnvoyFilterListenerMatchBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterListenerMatch(), validationEnabled);
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterListenerMatch(), validationEnabled);
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatchFluent<?> fluent,EnvoyFilterListenerMatch instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatchFluent<?> fluent,EnvoyFilterListenerMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new EnvoyFilterListenerMatch());

    if (instance != null) {
      fluent.withFilterChain(instance.getFilterChain());
      fluent.withName(instance.getName());
      fluent.withPortName(instance.getPortName());
      fluent.withPortNumber(instance.getPortNumber());
      fluent.withFilterChain(instance.getFilterChain());
      fluent.withName(instance.getName());
      fluent.withPortName(instance.getPortName());
      fluent.withPortNumber(instance.getPortNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatch instance) {
    this(instance,false);
  }
  public EnvoyFilterListenerMatchBuilder(EnvoyFilterListenerMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new EnvoyFilterListenerMatch());

    if (instance != null) {
      this.withFilterChain(instance.getFilterChain());
      this.withName(instance.getName());
      this.withPortName(instance.getPortName());
      this.withPortNumber(instance.getPortNumber());
      this.withFilterChain(instance.getFilterChain());
      this.withName(instance.getName());
      this.withPortName(instance.getPortName());
      this.withPortNumber(instance.getPortNumber());
    }
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterListenerMatchFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterListenerMatch build() {
    EnvoyFilterListenerMatch buildable = new EnvoyFilterListenerMatch(fluent.buildFilterChain(),fluent.getName(),fluent.getPortName(),fluent.getPortNumber());
    return buildable;
  }
  
}