package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DestinationRuleBuilder extends DestinationRuleFluent<DestinationRuleBuilder> implements VisitableBuilder<DestinationRule,DestinationRuleBuilder>{
  public DestinationRuleBuilder() {
    this(false);
  }
  public DestinationRuleBuilder(Boolean validationEnabled) {
    this(new DestinationRule(), validationEnabled);
  }
  public DestinationRuleBuilder(DestinationRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public DestinationRuleBuilder(DestinationRuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DestinationRule(), validationEnabled);
  }
  public DestinationRuleBuilder(DestinationRuleFluent<?> fluent,DestinationRule instance) {
    this(fluent, instance, false);
  }
  public DestinationRuleBuilder(DestinationRuleFluent<?> fluent,DestinationRule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new DestinationRule());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DestinationRuleBuilder(DestinationRule instance) {
    this(instance,false);
  }
  public DestinationRuleBuilder(DestinationRule instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new DestinationRule());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
    this.validationEnabled = validationEnabled; 
  }
  DestinationRuleFluent<?> fluent;
  Boolean validationEnabled;
  public DestinationRule build() {
    DestinationRule buildable = new DestinationRule(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    return buildable;
  }
  
}