package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClientTLSSettingsBuilder extends ClientTLSSettingsFluent<ClientTLSSettingsBuilder> implements VisitableBuilder<ClientTLSSettings,ClientTLSSettingsBuilder>{
  public ClientTLSSettingsBuilder() {
    this(false);
  }
  public ClientTLSSettingsBuilder(Boolean validationEnabled) {
    this(new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent,ClientTLSSettings instance) {
    this(fluent, instance, false);
  }
  public ClientTLSSettingsBuilder(ClientTLSSettingsFluent<?> fluent,ClientTLSSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ClientTLSSettings());

    if (instance != null) {
      fluent.withCaCertificates(instance.getCaCertificates());
      fluent.withClientCertificate(instance.getClientCertificate());
      fluent.withCredentialName(instance.getCredentialName());
      fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      fluent.withMode(instance.getMode());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withSni(instance.getSni());
      fluent.withSubjectAltNames(instance.getSubjectAltNames());
      fluent.withCaCertificates(instance.getCaCertificates());
      fluent.withClientCertificate(instance.getClientCertificate());
      fluent.withCredentialName(instance.getCredentialName());
      fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      fluent.withMode(instance.getMode());
      fluent.withPrivateKey(instance.getPrivateKey());
      fluent.withSni(instance.getSni());
      fluent.withSubjectAltNames(instance.getSubjectAltNames());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ClientTLSSettingsBuilder(ClientTLSSettings instance) {
    this(instance,false);
  }
  public ClientTLSSettingsBuilder(ClientTLSSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ClientTLSSettings());

    if (instance != null) {
      this.withCaCertificates(instance.getCaCertificates());
      this.withClientCertificate(instance.getClientCertificate());
      this.withCredentialName(instance.getCredentialName());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withMode(instance.getMode());
      this.withPrivateKey(instance.getPrivateKey());
      this.withSni(instance.getSni());
      this.withSubjectAltNames(instance.getSubjectAltNames());
      this.withCaCertificates(instance.getCaCertificates());
      this.withClientCertificate(instance.getClientCertificate());
      this.withCredentialName(instance.getCredentialName());
      this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
      this.withMode(instance.getMode());
      this.withPrivateKey(instance.getPrivateKey());
      this.withSni(instance.getSni());
      this.withSubjectAltNames(instance.getSubjectAltNames());
    }
    this.validationEnabled = validationEnabled; 
  }
  ClientTLSSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ClientTLSSettings build() {
    ClientTLSSettings buildable = new ClientTLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getCredentialName(),fluent.getInsecureSkipVerify(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
    return buildable;
  }
  
}