package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueNullValueBuilder extends ValueNullValueFluent<ValueNullValueBuilder> implements VisitableBuilder<ValueNullValue,ValueNullValueBuilder>{
  public ValueNullValueBuilder() {
    this(false);
  }
  public ValueNullValueBuilder(Boolean validationEnabled) {
    this(new ValueNullValue(), validationEnabled);
  }
  public ValueNullValueBuilder(ValueNullValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueNullValueBuilder(ValueNullValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValueNullValue(), validationEnabled);
  }
  public ValueNullValueBuilder(ValueNullValueFluent<?> fluent,ValueNullValue instance) {
    this(fluent, instance, false);
  }
  public ValueNullValueBuilder(ValueNullValueFluent<?> fluent,ValueNullValue instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValueNullValue());

    if (instance != null) {
      fluent.withNullValue(instance.getNullValue());
      fluent.withNullValue(instance.getNullValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValueNullValueBuilder(ValueNullValue instance) {
    this(instance,false);
  }
  public ValueNullValueBuilder(ValueNullValue instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValueNullValue());

    if (instance != null) {
      this.withNullValue(instance.getNullValue());
      this.withNullValue(instance.getNullValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValueNullValueFluent<?> fluent;
  Boolean validationEnabled;
  public ValueNullValue build() {
    ValueNullValue buildable = new ValueNullValue(fluent.getNullValue());
    return buildable;
  }
  
}