package io.fabric8.istio.api.analysis.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AnalysisMessageBaseBuilder extends AnalysisMessageBaseFluent<AnalysisMessageBaseBuilder> implements VisitableBuilder<AnalysisMessageBase,AnalysisMessageBaseBuilder>{
  public AnalysisMessageBaseBuilder() {
    this(false);
  }
  public AnalysisMessageBaseBuilder(Boolean validationEnabled) {
    this(new AnalysisMessageBase(), validationEnabled);
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBaseFluent<?> fluent) {
    this(fluent, false);
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBaseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AnalysisMessageBase(), validationEnabled);
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBaseFluent<?> fluent,AnalysisMessageBase instance) {
    this(fluent, instance, false);
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBaseFluent<?> fluent,AnalysisMessageBase instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AnalysisMessageBase());

    if (instance != null) {
      fluent.withDocumentationUrl(instance.getDocumentationUrl());
      fluent.withLevel(instance.getLevel());
      fluent.withType(instance.getType());
      fluent.withDocumentationUrl(instance.getDocumentationUrl());
      fluent.withLevel(instance.getLevel());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBase instance) {
    this(instance,false);
  }
  public AnalysisMessageBaseBuilder(AnalysisMessageBase instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AnalysisMessageBase());

    if (instance != null) {
      this.withDocumentationUrl(instance.getDocumentationUrl());
      this.withLevel(instance.getLevel());
      this.withType(instance.getType());
      this.withDocumentationUrl(instance.getDocumentationUrl());
      this.withLevel(instance.getLevel());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  AnalysisMessageBaseFluent<?> fluent;
  Boolean validationEnabled;
  public AnalysisMessageBase build() {
    AnalysisMessageBase buildable = new AnalysisMessageBase(fluent.getDocumentationUrl(),fluent.getLevel(),fluent.buildType());
    return buildable;
  }
  
}