package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatusFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import java.lang.Deprecated;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface VirtualServiceFluent<A extends VirtualServiceFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata();
  public ObjectMeta buildMetadata();
  public A withMetadata(ObjectMeta metadata);
  public Boolean hasMetadata();
  public VirtualServiceFluent.MetadataNested<A> withNewMetadata();
  public VirtualServiceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
  public VirtualServiceFluent.MetadataNested<A> editMetadata();
  public VirtualServiceFluent.MetadataNested<A> editOrNewMetadata();
  public VirtualServiceFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public VirtualServiceSpec getSpec();
  public VirtualServiceSpec buildSpec();
  public A withSpec(VirtualServiceSpec spec);
  public Boolean hasSpec();
  public VirtualServiceFluent.SpecNested<A> withNewSpec();
  public VirtualServiceFluent.SpecNested<A> withNewSpecLike(VirtualServiceSpec item);
  public VirtualServiceFluent.SpecNested<A> editSpec();
  public VirtualServiceFluent.SpecNested<A> editOrNewSpec();
  public VirtualServiceFluent.SpecNested<A> editOrNewSpecLike(VirtualServiceSpec item);
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public IstioStatus getStatus();
  public IstioStatus buildStatus();
  public A withStatus(IstioStatus status);
  public Boolean hasStatus();
  public VirtualServiceFluent.StatusNested<A> withNewStatus();
  public VirtualServiceFluent.StatusNested<A> withNewStatusLike(IstioStatus item);
  public VirtualServiceFluent.StatusNested<A> editStatus();
  public VirtualServiceFluent.StatusNested<A> editOrNewStatus();
  public VirtualServiceFluent.StatusNested<A> editOrNewStatusLike(IstioStatus item);
  public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<VirtualServiceFluent.MetadataNested<N>>{
    public N and();
    public N endMetadata();
    
  }
  public interface SpecNested<N> extends Nested<N>,VirtualServiceSpecFluent<VirtualServiceFluent.SpecNested<N>>{
    public N and();
    public N endSpec();
    
  }
  public interface StatusNested<N> extends Nested<N>,IstioStatusFluent<VirtualServiceFluent.StatusNested<N>>{
    public N and();
    public N endStatus();
    
  }
  
}