package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServerTLSSettingsFluentImpl<A extends ServerTLSSettingsFluent<A>> extends BaseFluent<A> implements ServerTLSSettingsFluent<A>{
  public ServerTLSSettingsFluentImpl() {
  }
  public ServerTLSSettingsFluentImpl(ServerTLSSettings instance) {
    if (instance != null) {
      this.withCaCertificates(instance.getCaCertificates());
      this.withCipherSuites(instance.getCipherSuites());
      this.withCredentialName(instance.getCredentialName());
      this.withHttpsRedirect(instance.getHttpsRedirect());
      this.withMaxProtocolVersion(instance.getMaxProtocolVersion());
      this.withMinProtocolVersion(instance.getMinProtocolVersion());
      this.withMode(instance.getMode());
      this.withPrivateKey(instance.getPrivateKey());
      this.withServerCertificate(instance.getServerCertificate());
      this.withSubjectAltNames(instance.getSubjectAltNames());
      this.withVerifyCertificateHash(instance.getVerifyCertificateHash());
      this.withVerifyCertificateSpki(instance.getVerifyCertificateSpki());
    }
  }
  private String caCertificates;
  private List<String> cipherSuites = new ArrayList<String>();
  private String credentialName;
  private Boolean httpsRedirect;
  private ServerTLSSettingsTLSProtocol maxProtocolVersion;
  private ServerTLSSettingsTLSProtocol minProtocolVersion;
  private ServerTLSSettingsTLSmode mode;
  private String privateKey;
  private String serverCertificate;
  private List<String> subjectAltNames = new ArrayList<String>();
  private List<String> verifyCertificateHash = new ArrayList<String>();
  private List<String> verifyCertificateSpki = new ArrayList<String>();
  public String getCaCertificates() {
    return this.caCertificates;
  }
  public A withCaCertificates(String caCertificates) {
    this.caCertificates=caCertificates; return (A) this;
  }
  public Boolean hasCaCertificates() {
    return this.caCertificates != null;
  }
  public A addToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.add(index, item);
    return (A)this;
  }
  public A setToCipherSuites(int index,String item) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    this.cipherSuites.set(index, item); return (A)this;
  }
  public A addToCipherSuites(java.lang.String... items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A addAllToCipherSuites(Collection<String> items) {
    if (this.cipherSuites == null) {this.cipherSuites = new ArrayList<String>();}
    for (String item : items) {this.cipherSuites.add(item);} return (A)this;
  }
  public A removeFromCipherSuites(java.lang.String... items) {
    for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public A removeAllFromCipherSuites(Collection<String> items) {
    for (String item : items) {if (this.cipherSuites!= null){ this.cipherSuites.remove(item);}} return (A)this;
  }
  public List<String> getCipherSuites() {
    return this.cipherSuites;
  }
  public String getCipherSuite(int index) {
    return this.cipherSuites.get(index);
  }
  public String getFirstCipherSuite() {
    return this.cipherSuites.get(0);
  }
  public String getLastCipherSuite() {
    return this.cipherSuites.get(cipherSuites.size() - 1);
  }
  public String getMatchingCipherSuite(Predicate<String> predicate) {
    for (String item: cipherSuites) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCipherSuite(Predicate<String> predicate) {
    for (String item: cipherSuites) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withCipherSuites(List<String> cipherSuites) {
    if (cipherSuites != null) {this.cipherSuites = new ArrayList(); for (String item : cipherSuites){this.addToCipherSuites(item);}} else { this.cipherSuites = null;} return (A) this;
  }
  public A withCipherSuites(java.lang.String... cipherSuites) {
    if (this.cipherSuites != null) {this.cipherSuites.clear(); _visitables.remove("cipherSuites"); }
    if (cipherSuites != null) {for (String item :cipherSuites){ this.addToCipherSuites(item);}} return (A) this;
  }
  public Boolean hasCipherSuites() {
    return cipherSuites != null && !cipherSuites.isEmpty();
  }
  public String getCredentialName() {
    return this.credentialName;
  }
  public A withCredentialName(String credentialName) {
    this.credentialName=credentialName; return (A) this;
  }
  public Boolean hasCredentialName() {
    return this.credentialName != null;
  }
  public Boolean getHttpsRedirect() {
    return this.httpsRedirect;
  }
  public A withHttpsRedirect(Boolean httpsRedirect) {
    this.httpsRedirect=httpsRedirect; return (A) this;
  }
  public Boolean hasHttpsRedirect() {
    return this.httpsRedirect != null;
  }
  public ServerTLSSettingsTLSProtocol getMaxProtocolVersion() {
    return this.maxProtocolVersion;
  }
  public A withMaxProtocolVersion(ServerTLSSettingsTLSProtocol maxProtocolVersion) {
    this.maxProtocolVersion=maxProtocolVersion; return (A) this;
  }
  public Boolean hasMaxProtocolVersion() {
    return this.maxProtocolVersion != null;
  }
  public ServerTLSSettingsTLSProtocol getMinProtocolVersion() {
    return this.minProtocolVersion;
  }
  public A withMinProtocolVersion(ServerTLSSettingsTLSProtocol minProtocolVersion) {
    this.minProtocolVersion=minProtocolVersion; return (A) this;
  }
  public Boolean hasMinProtocolVersion() {
    return this.minProtocolVersion != null;
  }
  public ServerTLSSettingsTLSmode getMode() {
    return this.mode;
  }
  public A withMode(ServerTLSSettingsTLSmode mode) {
    this.mode=mode; return (A) this;
  }
  public Boolean hasMode() {
    return this.mode != null;
  }
  public String getPrivateKey() {
    return this.privateKey;
  }
  public A withPrivateKey(String privateKey) {
    this.privateKey=privateKey; return (A) this;
  }
  public Boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  public String getServerCertificate() {
    return this.serverCertificate;
  }
  public A withServerCertificate(String serverCertificate) {
    this.serverCertificate=serverCertificate; return (A) this;
  }
  public Boolean hasServerCertificate() {
    return this.serverCertificate != null;
  }
  public A addToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  public A setToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A addAllToSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A removeFromSubjectAltNames(java.lang.String... items) {
    for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public A removeAllFromSubjectAltNames(Collection<String> items) {
    for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public List<String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  public String getSubjectAltName(int index) {
    return this.subjectAltNames.get(index);
  }
  public String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  public String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  public String getMatchingSubjectAltName(Predicate<String> predicate) {
    for (String item: subjectAltNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
    for (String item: subjectAltNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjectAltNames(List<String> subjectAltNames) {
    if (subjectAltNames != null) {this.subjectAltNames = new ArrayList(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
  }
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {this.subjectAltNames.clear(); _visitables.remove("subjectAltNames"); }
    if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
  }
  public Boolean hasSubjectAltNames() {
    return subjectAltNames != null && !subjectAltNames.isEmpty();
  }
  public A addToVerifyCertificateHash(int index,String item) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
    this.verifyCertificateHash.add(index, item);
    return (A)this;
  }
  public A setToVerifyCertificateHash(int index,String item) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
    this.verifyCertificateHash.set(index, item); return (A)this;
  }
  public A addToVerifyCertificateHash(java.lang.String... items) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
    for (String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
  }
  public A addAllToVerifyCertificateHash(Collection<String> items) {
    if (this.verifyCertificateHash == null) {this.verifyCertificateHash = new ArrayList<String>();}
    for (String item : items) {this.verifyCertificateHash.add(item);} return (A)this;
  }
  public A removeFromVerifyCertificateHash(java.lang.String... items) {
    for (String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
  }
  public A removeAllFromVerifyCertificateHash(Collection<String> items) {
    for (String item : items) {if (this.verifyCertificateHash!= null){ this.verifyCertificateHash.remove(item);}} return (A)this;
  }
  public List<String> getVerifyCertificateHash() {
    return this.verifyCertificateHash;
  }
  public String getVerifyCertificateHash(int index) {
    return this.verifyCertificateHash.get(index);
  }
  public String getFirstVerifyCertificateHash() {
    return this.verifyCertificateHash.get(0);
  }
  public String getLastVerifyCertificateHash() {
    return this.verifyCertificateHash.get(verifyCertificateHash.size() - 1);
  }
  public String getMatchingVerifyCertificateHash(Predicate<String> predicate) {
    for (String item: verifyCertificateHash) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerifyCertificateHash(Predicate<String> predicate) {
    for (String item: verifyCertificateHash) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerifyCertificateHash(List<String> verifyCertificateHash) {
    if (verifyCertificateHash != null) {this.verifyCertificateHash = new ArrayList(); for (String item : verifyCertificateHash){this.addToVerifyCertificateHash(item);}} else { this.verifyCertificateHash = null;} return (A) this;
  }
  public A withVerifyCertificateHash(java.lang.String... verifyCertificateHash) {
    if (this.verifyCertificateHash != null) {this.verifyCertificateHash.clear(); _visitables.remove("verifyCertificateHash"); }
    if (verifyCertificateHash != null) {for (String item :verifyCertificateHash){ this.addToVerifyCertificateHash(item);}} return (A) this;
  }
  public Boolean hasVerifyCertificateHash() {
    return verifyCertificateHash != null && !verifyCertificateHash.isEmpty();
  }
  public A addToVerifyCertificateSpki(int index,String item) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
    this.verifyCertificateSpki.add(index, item);
    return (A)this;
  }
  public A setToVerifyCertificateSpki(int index,String item) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
    this.verifyCertificateSpki.set(index, item); return (A)this;
  }
  public A addToVerifyCertificateSpki(java.lang.String... items) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
    for (String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
  }
  public A addAllToVerifyCertificateSpki(Collection<String> items) {
    if (this.verifyCertificateSpki == null) {this.verifyCertificateSpki = new ArrayList<String>();}
    for (String item : items) {this.verifyCertificateSpki.add(item);} return (A)this;
  }
  public A removeFromVerifyCertificateSpki(java.lang.String... items) {
    for (String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
  }
  public A removeAllFromVerifyCertificateSpki(Collection<String> items) {
    for (String item : items) {if (this.verifyCertificateSpki!= null){ this.verifyCertificateSpki.remove(item);}} return (A)this;
  }
  public List<String> getVerifyCertificateSpki() {
    return this.verifyCertificateSpki;
  }
  public String getVerifyCertificateSpki(int index) {
    return this.verifyCertificateSpki.get(index);
  }
  public String getFirstVerifyCertificateSpki() {
    return this.verifyCertificateSpki.get(0);
  }
  public String getLastVerifyCertificateSpki() {
    return this.verifyCertificateSpki.get(verifyCertificateSpki.size() - 1);
  }
  public String getMatchingVerifyCertificateSpki(Predicate<String> predicate) {
    for (String item: verifyCertificateSpki) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingVerifyCertificateSpki(Predicate<String> predicate) {
    for (String item: verifyCertificateSpki) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVerifyCertificateSpki(List<String> verifyCertificateSpki) {
    if (verifyCertificateSpki != null) {this.verifyCertificateSpki = new ArrayList(); for (String item : verifyCertificateSpki){this.addToVerifyCertificateSpki(item);}} else { this.verifyCertificateSpki = null;} return (A) this;
  }
  public A withVerifyCertificateSpki(java.lang.String... verifyCertificateSpki) {
    if (this.verifyCertificateSpki != null) {this.verifyCertificateSpki.clear(); _visitables.remove("verifyCertificateSpki"); }
    if (verifyCertificateSpki != null) {for (String item :verifyCertificateSpki){ this.addToVerifyCertificateSpki(item);}} return (A) this;
  }
  public Boolean hasVerifyCertificateSpki() {
    return verifyCertificateSpki != null && !verifyCertificateSpki.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ServerTLSSettingsFluentImpl that = (ServerTLSSettingsFluentImpl) o;
    if (!java.util.Objects.equals(caCertificates, that.caCertificates)) return false;

    if (!java.util.Objects.equals(cipherSuites, that.cipherSuites)) return false;

    if (!java.util.Objects.equals(credentialName, that.credentialName)) return false;

    if (!java.util.Objects.equals(httpsRedirect, that.httpsRedirect)) return false;

    if (!java.util.Objects.equals(maxProtocolVersion, that.maxProtocolVersion)) return false;

    if (!java.util.Objects.equals(minProtocolVersion, that.minProtocolVersion)) return false;

    if (!java.util.Objects.equals(mode, that.mode)) return false;

    if (!java.util.Objects.equals(privateKey, that.privateKey)) return false;

    if (!java.util.Objects.equals(serverCertificate, that.serverCertificate)) return false;

    if (!java.util.Objects.equals(subjectAltNames, that.subjectAltNames)) return false;

    if (!java.util.Objects.equals(verifyCertificateHash, that.verifyCertificateHash)) return false;

    if (!java.util.Objects.equals(verifyCertificateSpki, that.verifyCertificateSpki)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caCertificates,  cipherSuites,  credentialName,  httpsRedirect,  maxProtocolVersion,  minProtocolVersion,  mode,  privateKey,  serverCertificate,  subjectAltNames,  verifyCertificateHash,  verifyCertificateSpki,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caCertificates != null) { sb.append("caCertificates:"); sb.append(caCertificates + ","); }
    if (cipherSuites != null && !cipherSuites.isEmpty()) { sb.append("cipherSuites:"); sb.append(cipherSuites + ","); }
    if (credentialName != null) { sb.append("credentialName:"); sb.append(credentialName + ","); }
    if (httpsRedirect != null) { sb.append("httpsRedirect:"); sb.append(httpsRedirect + ","); }
    if (maxProtocolVersion != null) { sb.append("maxProtocolVersion:"); sb.append(maxProtocolVersion + ","); }
    if (minProtocolVersion != null) { sb.append("minProtocolVersion:"); sb.append(minProtocolVersion + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (serverCertificate != null) { sb.append("serverCertificate:"); sb.append(serverCertificate + ","); }
    if (subjectAltNames != null && !subjectAltNames.isEmpty()) { sb.append("subjectAltNames:"); sb.append(subjectAltNames + ","); }
    if (verifyCertificateHash != null && !verifyCertificateHash.isEmpty()) { sb.append("verifyCertificateHash:"); sb.append(verifyCertificateHash + ","); }
    if (verifyCertificateSpki != null && !verifyCertificateSpki.isEmpty()) { sb.append("verifyCertificateSpki:"); sb.append(verifyCertificateSpki); }
    sb.append("}");
    return sb.toString();
  }
  public A withHttpsRedirect() {
    return withHttpsRedirect(true);
  }
  
}