package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PercentBuilder extends PercentFluentImpl<PercentBuilder> implements VisitableBuilder<Percent,PercentBuilder>{
  public PercentBuilder() {
    this(false);
  }
  public PercentBuilder(Boolean validationEnabled) {
    this(new Percent(), validationEnabled);
  }
  public PercentBuilder(PercentFluent<?> fluent) {
    this(fluent, false);
  }
  public PercentBuilder(PercentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Percent(), validationEnabled);
  }
  public PercentBuilder(PercentFluent<?> fluent,Percent instance) {
    this(fluent, instance, false);
  }
  public PercentBuilder(PercentFluent<?> fluent,Percent instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PercentBuilder(Percent instance) {
    this(instance,false);
  }
  public PercentBuilder(Percent instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withValue(instance.getValue());
    }
    this.validationEnabled = validationEnabled; 
  }
  PercentFluent<?> fluent;
  Boolean validationEnabled;
  public Percent build() {
    Percent buildable = new Percent(fluent.getValue());
    return buildable;
  }
  
}