package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPRedirectFluentImpl<A extends HTTPRedirectFluent<A>> extends BaseFluent<A> implements HTTPRedirectFluent<A>{
  public HTTPRedirectFluentImpl() {
  }
  public HTTPRedirectFluentImpl(HTTPRedirect instance) {
    if (instance != null) {
      this.withRedirectPort(instance.getRedirectPort());
      this.withAuthority(instance.getAuthority());
      this.withRedirectCode(instance.getRedirectCode());
      this.withScheme(instance.getScheme());
      this.withUri(instance.getUri());
    }
  }
  private VisitableBuilder<? extends IsHTTPRedirectRedirectPort,?> redirectPort;
  private String authority;
  private Integer redirectCode;
  private String scheme;
  private String uri;
  
  /**
   * This method has been deprecated, please use method buildRedirectPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public IsHTTPRedirectRedirectPort getRedirectPort() {
    return this.redirectPort!=null?this.redirectPort.build():null;
  }
  public IsHTTPRedirectRedirectPort buildRedirectPort() {
    return this.redirectPort!=null?this.redirectPort.build():null;
  }
  public A withRedirectPort(IsHTTPRedirectRedirectPort redirectPort) {
    if (redirectPort==null){ this.redirectPort = null; _visitables.remove("redirectPort"); return (A) this;}
    if (redirectPort instanceof HTTPRedirectPort){ this.redirectPort= new HTTPRedirectPortBuilder((HTTPRedirectPort)redirectPort); _visitables.get("redirectPort").clear(); _visitables.get("redirectPort").add(this.redirectPort);}
    if (redirectPort instanceof HTTPRedirectDerivePort){ this.redirectPort= new HTTPRedirectDerivePortBuilder((HTTPRedirectDerivePort)redirectPort); _visitables.get("redirectPort").clear(); _visitables.get("redirectPort").add(this.redirectPort);}
    VisitableBuilder<? extends IsHTTPRedirectRedirectPort,?> builder = builderOf(redirectPort); _visitables.get("redirectPort").clear();_visitables.get("redirectPort").add(builder);this.redirectPort = builder;
    return (A) this;
  }
  public Boolean hasRedirectPort() {
    return this.redirectPort != null;
  }
  public A withHTTPRedirectPort(HTTPRedirectPort hTTPRedirectPort) {
    _visitables.get("redirectPort").remove(this.redirectPort);
    if (hTTPRedirectPort!=null){ this.redirectPort= new HTTPRedirectPortBuilder(hTTPRedirectPort); _visitables.get("redirectPort").add(this.redirectPort);} else { this.redirectPort = null; _visitables.get("redirectPort").remove(this.redirectPort); } return (A) this;
  }
  public HTTPRedirectFluentImpl.HTTPRedirectPortNested<A> withNewHTTPRedirectPort() {
    return new HTTPRedirectFluentImpl.HTTPRedirectPortNestedImpl();
  }
  public HTTPRedirectFluentImpl.HTTPRedirectPortNested<A> withNewHTTPRedirectPortLike(HTTPRedirectPort item) {
    return new HTTPRedirectFluentImpl.HTTPRedirectPortNestedImpl(item);
  }
  public A withNewHTTPRedirectPort(Integer port) {
    return (A)withHTTPRedirectPort(new HTTPRedirectPort(port));
  }
  public A withHTTPRedirectDerivePort(HTTPRedirectDerivePort hTTPRedirectDerivePort) {
    _visitables.get("redirectPort").remove(this.redirectPort);
    if (hTTPRedirectDerivePort!=null){ this.redirectPort= new HTTPRedirectDerivePortBuilder(hTTPRedirectDerivePort); _visitables.get("redirectPort").add(this.redirectPort);} else { this.redirectPort = null; _visitables.get("redirectPort").remove(this.redirectPort); } return (A) this;
  }
  public HTTPRedirectFluentImpl.HTTPRedirectDerivePortNested<A> withNewHTTPRedirectDerivePort() {
    return new HTTPRedirectFluentImpl.HTTPRedirectDerivePortNestedImpl();
  }
  public HTTPRedirectFluentImpl.HTTPRedirectDerivePortNested<A> withNewHTTPRedirectDerivePortLike(HTTPRedirectDerivePort item) {
    return new HTTPRedirectFluentImpl.HTTPRedirectDerivePortNestedImpl(item);
  }
  public String getAuthority() {
    return this.authority;
  }
  public A withAuthority(String authority) {
    this.authority=authority; return (A) this;
  }
  public Boolean hasAuthority() {
    return this.authority != null;
  }
  public Integer getRedirectCode() {
    return this.redirectCode;
  }
  public A withRedirectCode(Integer redirectCode) {
    this.redirectCode=redirectCode; return (A) this;
  }
  public Boolean hasRedirectCode() {
    return this.redirectCode != null;
  }
  public String getScheme() {
    return this.scheme;
  }
  public A withScheme(String scheme) {
    this.scheme=scheme; return (A) this;
  }
  public Boolean hasScheme() {
    return this.scheme != null;
  }
  public String getUri() {
    return this.uri;
  }
  public A withUri(String uri) {
    this.uri=uri; return (A) this;
  }
  public Boolean hasUri() {
    return this.uri != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRedirectFluentImpl that = (HTTPRedirectFluentImpl) o;
    if (!java.util.Objects.equals(redirectPort, that.redirectPort)) return false;

    if (!java.util.Objects.equals(authority, that.authority)) return false;

    if (!java.util.Objects.equals(redirectCode, that.redirectCode)) return false;

    if (!java.util.Objects.equals(scheme, that.scheme)) return false;

    if (!java.util.Objects.equals(uri, that.uri)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(redirectPort,  authority,  redirectCode,  scheme,  uri,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (redirectPort != null) { sb.append("redirectPort:"); sb.append(redirectPort + ","); }
    if (authority != null) { sb.append("authority:"); sb.append(authority + ","); }
    if (redirectCode != null) { sb.append("redirectCode:"); sb.append(redirectCode + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri); }
    sb.append("}");
    return sb.toString();
  }
  class HTTPRedirectPortNestedImpl<N> extends HTTPRedirectPortFluentImpl<HTTPRedirectFluentImpl.HTTPRedirectPortNested<N>> implements HTTPRedirectFluentImpl.HTTPRedirectPortNested<N>,Nested<N>{
    HTTPRedirectPortNestedImpl(HTTPRedirectPort item) {
      this.builder = new HTTPRedirectPortBuilder(this, item);
    }
    HTTPRedirectPortNestedImpl() {
      this.builder = new HTTPRedirectPortBuilder(this);
    }
    HTTPRedirectPortBuilder builder;
    public N and() {
      return (N) HTTPRedirectFluentImpl.this.withRedirectPort(builder.build());
    }
    public N endHTTPRedirectPort() {
      return and();
    }
    
  }
  class HTTPRedirectDerivePortNestedImpl<N> extends HTTPRedirectDerivePortFluentImpl<HTTPRedirectFluentImpl.HTTPRedirectDerivePortNested<N>> implements HTTPRedirectFluentImpl.HTTPRedirectDerivePortNested<N>,Nested<N>{
    HTTPRedirectDerivePortNestedImpl(HTTPRedirectDerivePort item) {
      this.builder = new HTTPRedirectDerivePortBuilder(this, item);
    }
    HTTPRedirectDerivePortNestedImpl() {
      this.builder = new HTTPRedirectDerivePortBuilder(this);
    }
    HTTPRedirectDerivePortBuilder builder;
    public N and() {
      return (N) HTTPRedirectFluentImpl.this.withRedirectPort(builder.build());
    }
    public N endHTTPRedirectDerivePort() {
      return and();
    }
    
  }
  
}