package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPFaultInjectionAbortBuilder extends HTTPFaultInjectionAbortFluentImpl<HTTPFaultInjectionAbortBuilder> implements VisitableBuilder<HTTPFaultInjectionAbort,HTTPFaultInjectionAbortBuilder>{
  public HTTPFaultInjectionAbortBuilder() {
    this(false);
  }
  public HTTPFaultInjectionAbortBuilder(Boolean validationEnabled) {
    this(new HTTPFaultInjectionAbort(), validationEnabled);
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbortFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbortFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPFaultInjectionAbort(), validationEnabled);
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbortFluent<?> fluent,HTTPFaultInjectionAbort instance) {
    this(fluent, instance, false);
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbortFluent<?> fluent,HTTPFaultInjectionAbort instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withErrorType(instance.getErrorType());
      fluent.withPercentage(instance.getPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbort instance) {
    this(instance,false);
  }
  public HTTPFaultInjectionAbortBuilder(HTTPFaultInjectionAbort instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withErrorType(instance.getErrorType());
      this.withPercentage(instance.getPercentage());
    }
    this.validationEnabled = validationEnabled; 
  }
  HTTPFaultInjectionAbortFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPFaultInjectionAbort build() {
    HTTPFaultInjectionAbort buildable = new HTTPFaultInjectionAbort(fluent.getErrorType(),fluent.getPercentage());
    return buildable;
  }
  
}