package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CorsPolicyFluentImpl<A extends CorsPolicyFluent<A>> extends BaseFluent<A> implements CorsPolicyFluent<A>{
  public CorsPolicyFluentImpl() {
  }
  public CorsPolicyFluentImpl(CorsPolicy instance) {
    if (instance != null) {
      this.withAllowCredentials(instance.getAllowCredentials());
      this.withAllowHeaders(instance.getAllowHeaders());
      this.withAllowMethods(instance.getAllowMethods());
      this.withDeprecatedAllowOrigin(instance.getDeprecatedAllowOrigin());
      this.withAllowOrigins(instance.getAllowOrigins());
      this.withExposeHeaders(instance.getExposeHeaders());
      this.withMaxAge(instance.getMaxAge());
    }
  }
  private Boolean allowCredentials;
  private List<String> allowHeaders;
  private List<String> allowMethods;
  private List<String> deprecatedAllowOrigin;
  private ArrayList<StringMatchBuilder> allowOrigins;
  private List<String> exposeHeaders;
  private String maxAge;
  public Boolean getAllowCredentials() {
    return this.allowCredentials;
  }
  public A withAllowCredentials(Boolean allowCredentials) {
    this.allowCredentials=allowCredentials; return (A) this;
  }
  public Boolean hasAllowCredentials() {
    return this.allowCredentials != null;
  }
  public A addToAllowHeaders(int index,String item) {
    if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
    this.allowHeaders.add(index, item);
    return (A)this;
  }
  public A setToAllowHeaders(int index,String item) {
    if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
    this.allowHeaders.set(index, item); return (A)this;
  }
  public A addToAllowHeaders(java.lang.String... items) {
    if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
    for (String item : items) {this.allowHeaders.add(item);} return (A)this;
  }
  public A addAllToAllowHeaders(Collection<String> items) {
    if (this.allowHeaders == null) {this.allowHeaders = new ArrayList<String>();}
    for (String item : items) {this.allowHeaders.add(item);} return (A)this;
  }
  public A removeFromAllowHeaders(java.lang.String... items) {
    for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowHeaders(Collection<String> items) {
    for (String item : items) {if (this.allowHeaders!= null){ this.allowHeaders.remove(item);}} return (A)this;
  }
  public List<String> getAllowHeaders() {
    return this.allowHeaders;
  }
  public String getAllowHeader(int index) {
    return this.allowHeaders.get(index);
  }
  public String getFirstAllowHeader() {
    return this.allowHeaders.get(0);
  }
  public String getLastAllowHeader() {
    return this.allowHeaders.get(allowHeaders.size() - 1);
  }
  public String getMatchingAllowHeader(Predicate<String> predicate) {
    for (String item: allowHeaders) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowHeader(Predicate<String> predicate) {
    for (String item: allowHeaders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowHeaders(List<String> allowHeaders) {
    if (allowHeaders != null) {this.allowHeaders = new ArrayList(); for (String item : allowHeaders){this.addToAllowHeaders(item);}} else { this.allowHeaders = null;} return (A) this;
  }
  public A withAllowHeaders(java.lang.String... allowHeaders) {
    if (this.allowHeaders != null) {this.allowHeaders.clear(); _visitables.remove("allowHeaders"); }
    if (allowHeaders != null) {for (String item :allowHeaders){ this.addToAllowHeaders(item);}} return (A) this;
  }
  public Boolean hasAllowHeaders() {
    return allowHeaders != null && !allowHeaders.isEmpty();
  }
  public A addToAllowMethods(int index,String item) {
    if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
    this.allowMethods.add(index, item);
    return (A)this;
  }
  public A setToAllowMethods(int index,String item) {
    if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
    this.allowMethods.set(index, item); return (A)this;
  }
  public A addToAllowMethods(java.lang.String... items) {
    if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
    for (String item : items) {this.allowMethods.add(item);} return (A)this;
  }
  public A addAllToAllowMethods(Collection<String> items) {
    if (this.allowMethods == null) {this.allowMethods = new ArrayList<String>();}
    for (String item : items) {this.allowMethods.add(item);} return (A)this;
  }
  public A removeFromAllowMethods(java.lang.String... items) {
    for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
  }
  public A removeAllFromAllowMethods(Collection<String> items) {
    for (String item : items) {if (this.allowMethods!= null){ this.allowMethods.remove(item);}} return (A)this;
  }
  public List<String> getAllowMethods() {
    return this.allowMethods;
  }
  public String getAllowMethod(int index) {
    return this.allowMethods.get(index);
  }
  public String getFirstAllowMethod() {
    return this.allowMethods.get(0);
  }
  public String getLastAllowMethod() {
    return this.allowMethods.get(allowMethods.size() - 1);
  }
  public String getMatchingAllowMethod(Predicate<String> predicate) {
    for (String item: allowMethods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAllowMethod(Predicate<String> predicate) {
    for (String item: allowMethods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowMethods(List<String> allowMethods) {
    if (allowMethods != null) {this.allowMethods = new ArrayList(); for (String item : allowMethods){this.addToAllowMethods(item);}} else { this.allowMethods = null;} return (A) this;
  }
  public A withAllowMethods(java.lang.String... allowMethods) {
    if (this.allowMethods != null) {this.allowMethods.clear(); _visitables.remove("allowMethods"); }
    if (allowMethods != null) {for (String item :allowMethods){ this.addToAllowMethods(item);}} return (A) this;
  }
  public Boolean hasAllowMethods() {
    return allowMethods != null && !allowMethods.isEmpty();
  }
  public A addToDeprecatedAllowOrigin(int index,String item) {
    if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
    this.deprecatedAllowOrigin.add(index, item);
    return (A)this;
  }
  public A setToDeprecatedAllowOrigin(int index,String item) {
    if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
    this.deprecatedAllowOrigin.set(index, item); return (A)this;
  }
  public A addToDeprecatedAllowOrigin(java.lang.String... items) {
    if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
    for (String item : items) {this.deprecatedAllowOrigin.add(item);} return (A)this;
  }
  public A addAllToDeprecatedAllowOrigin(Collection<String> items) {
    if (this.deprecatedAllowOrigin == null) {this.deprecatedAllowOrigin = new ArrayList<String>();}
    for (String item : items) {this.deprecatedAllowOrigin.add(item);} return (A)this;
  }
  public A removeFromDeprecatedAllowOrigin(java.lang.String... items) {
    for (String item : items) {if (this.deprecatedAllowOrigin!= null){ this.deprecatedAllowOrigin.remove(item);}} return (A)this;
  }
  public A removeAllFromDeprecatedAllowOrigin(Collection<String> items) {
    for (String item : items) {if (this.deprecatedAllowOrigin!= null){ this.deprecatedAllowOrigin.remove(item);}} return (A)this;
  }
  public List<String> getDeprecatedAllowOrigin() {
    return this.deprecatedAllowOrigin;
  }
  public String getDeprecatedAllowOrigin(int index) {
    return this.deprecatedAllowOrigin.get(index);
  }
  public String getFirstDeprecatedAllowOrigin() {
    return this.deprecatedAllowOrigin.get(0);
  }
  public String getLastDeprecatedAllowOrigin() {
    return this.deprecatedAllowOrigin.get(deprecatedAllowOrigin.size() - 1);
  }
  public String getMatchingDeprecatedAllowOrigin(Predicate<String> predicate) {
    for (String item: deprecatedAllowOrigin) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingDeprecatedAllowOrigin(Predicate<String> predicate) {
    for (String item: deprecatedAllowOrigin) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDeprecatedAllowOrigin(List<String> deprecatedAllowOrigin) {
    if (deprecatedAllowOrigin != null) {this.deprecatedAllowOrigin = new ArrayList(); for (String item : deprecatedAllowOrigin){this.addToDeprecatedAllowOrigin(item);}} else { this.deprecatedAllowOrigin = null;} return (A) this;
  }
  public A withDeprecatedAllowOrigin(java.lang.String... deprecatedAllowOrigin) {
    if (this.deprecatedAllowOrigin != null) {this.deprecatedAllowOrigin.clear(); _visitables.remove("deprecatedAllowOrigin"); }
    if (deprecatedAllowOrigin != null) {for (String item :deprecatedAllowOrigin){ this.addToDeprecatedAllowOrigin(item);}} return (A) this;
  }
  public Boolean hasDeprecatedAllowOrigin() {
    return deprecatedAllowOrigin != null && !deprecatedAllowOrigin.isEmpty();
  }
  public A addToAllowOrigins(int index,StringMatch item) {
    if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
    StringMatchBuilder builder = new StringMatchBuilder(item);
    if (index < 0 || index >= allowOrigins.size()) { _visitables.get("allowOrigins").add(builder); allowOrigins.add(builder); } else { _visitables.get("allowOrigins").add(index, builder); allowOrigins.add(index, builder);}
    return (A)this;
  }
  public A setToAllowOrigins(int index,StringMatch item) {
    if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
    StringMatchBuilder builder = new StringMatchBuilder(item);
    if (index < 0 || index >= allowOrigins.size()) { _visitables.get("allowOrigins").add(builder); allowOrigins.add(builder); } else { _visitables.get("allowOrigins").set(index, builder); allowOrigins.set(index, builder);}
    return (A)this;
  }
  public A addToAllowOrigins(io.fabric8.istio.api.networking.v1alpha3.StringMatch... items) {
    if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
    for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").add(builder);this.allowOrigins.add(builder);} return (A)this;
  }
  public A addAllToAllowOrigins(Collection<StringMatch> items) {
    if (this.allowOrigins == null) {this.allowOrigins = new ArrayList<StringMatchBuilder>();}
    for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").add(builder);this.allowOrigins.add(builder);} return (A)this;
  }
  public A removeFromAllowOrigins(io.fabric8.istio.api.networking.v1alpha3.StringMatch... items) {
    for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").remove(builder);if (this.allowOrigins != null) {this.allowOrigins.remove(builder);}} return (A)this;
  }
  public A removeAllFromAllowOrigins(Collection<StringMatch> items) {
    for (StringMatch item : items) {StringMatchBuilder builder = new StringMatchBuilder(item);_visitables.get("allowOrigins").remove(builder);if (this.allowOrigins != null) {this.allowOrigins.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromAllowOrigins(Predicate<StringMatchBuilder> predicate) {
    if (allowOrigins == null) return (A) this;
    final Iterator<StringMatchBuilder> each = allowOrigins.iterator();
    final List visitables = _visitables.get("allowOrigins");
    while (each.hasNext()) {
      StringMatchBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildAllowOrigins instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<StringMatch> getAllowOrigins() {
    return allowOrigins != null ? build(allowOrigins) : null;
  }
  public List<StringMatch> buildAllowOrigins() {
    return allowOrigins != null ? build(allowOrigins) : null;
  }
  public StringMatch buildAllowOrigin(int index) {
    return this.allowOrigins.get(index).build();
  }
  public StringMatch buildFirstAllowOrigin() {
    return this.allowOrigins.get(0).build();
  }
  public StringMatch buildLastAllowOrigin() {
    return this.allowOrigins.get(allowOrigins.size() - 1).build();
  }
  public StringMatch buildMatchingAllowOrigin(Predicate<StringMatchBuilder> predicate) {
    for (StringMatchBuilder item: allowOrigins) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingAllowOrigin(Predicate<StringMatchBuilder> predicate) {
    for (StringMatchBuilder item: allowOrigins) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAllowOrigins(List<StringMatch> allowOrigins) {
    if (this.allowOrigins != null) { _visitables.get("allowOrigins").clear();}
    if (allowOrigins != null) {this.allowOrigins = new ArrayList(); for (StringMatch item : allowOrigins){this.addToAllowOrigins(item);}} else { this.allowOrigins = null;} return (A) this;
  }
  public A withAllowOrigins(io.fabric8.istio.api.networking.v1alpha3.StringMatch... allowOrigins) {
    if (this.allowOrigins != null) {this.allowOrigins.clear(); _visitables.remove("allowOrigins"); }
    if (allowOrigins != null) {for (StringMatch item :allowOrigins){ this.addToAllowOrigins(item);}} return (A) this;
  }
  public Boolean hasAllowOrigins() {
    return allowOrigins != null && !allowOrigins.isEmpty();
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> addNewAllowOrigin() {
    return new CorsPolicyFluentImpl.AllowOriginsNestedImpl();
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> addNewAllowOriginLike(StringMatch item) {
    return new CorsPolicyFluentImpl.AllowOriginsNestedImpl(-1, item);
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> setNewAllowOriginLike(int index,StringMatch item) {
    return new CorsPolicyFluentImpl.AllowOriginsNestedImpl(index, item);
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> editAllowOrigin(int index) {
    if (allowOrigins.size() <= index) throw new RuntimeException("Can't edit allowOrigins. Index exceeds size.");
    return setNewAllowOriginLike(index, buildAllowOrigin(index));
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> editFirstAllowOrigin() {
    if (allowOrigins.size() == 0) throw new RuntimeException("Can't edit first allowOrigins. The list is empty.");
    return setNewAllowOriginLike(0, buildAllowOrigin(0));
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> editLastAllowOrigin() {
    int index = allowOrigins.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last allowOrigins. The list is empty.");
    return setNewAllowOriginLike(index, buildAllowOrigin(index));
  }
  public CorsPolicyFluentImpl.AllowOriginsNested<A> editMatchingAllowOrigin(Predicate<StringMatchBuilder> predicate) {
    int index = -1;
    for (int i=0;i<allowOrigins.size();i++) { 
    if (predicate.test(allowOrigins.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching allowOrigins. No match found.");
    return setNewAllowOriginLike(index, buildAllowOrigin(index));
  }
  public A addToExposeHeaders(int index,String item) {
    if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
    this.exposeHeaders.add(index, item);
    return (A)this;
  }
  public A setToExposeHeaders(int index,String item) {
    if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
    this.exposeHeaders.set(index, item); return (A)this;
  }
  public A addToExposeHeaders(java.lang.String... items) {
    if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
    for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
  }
  public A addAllToExposeHeaders(Collection<String> items) {
    if (this.exposeHeaders == null) {this.exposeHeaders = new ArrayList<String>();}
    for (String item : items) {this.exposeHeaders.add(item);} return (A)this;
  }
  public A removeFromExposeHeaders(java.lang.String... items) {
    for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
  }
  public A removeAllFromExposeHeaders(Collection<String> items) {
    for (String item : items) {if (this.exposeHeaders!= null){ this.exposeHeaders.remove(item);}} return (A)this;
  }
  public List<String> getExposeHeaders() {
    return this.exposeHeaders;
  }
  public String getExposeHeader(int index) {
    return this.exposeHeaders.get(index);
  }
  public String getFirstExposeHeader() {
    return this.exposeHeaders.get(0);
  }
  public String getLastExposeHeader() {
    return this.exposeHeaders.get(exposeHeaders.size() - 1);
  }
  public String getMatchingExposeHeader(Predicate<String> predicate) {
    for (String item: exposeHeaders) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExposeHeader(Predicate<String> predicate) {
    for (String item: exposeHeaders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExposeHeaders(List<String> exposeHeaders) {
    if (exposeHeaders != null) {this.exposeHeaders = new ArrayList(); for (String item : exposeHeaders){this.addToExposeHeaders(item);}} else { this.exposeHeaders = null;} return (A) this;
  }
  public A withExposeHeaders(java.lang.String... exposeHeaders) {
    if (this.exposeHeaders != null) {this.exposeHeaders.clear(); _visitables.remove("exposeHeaders"); }
    if (exposeHeaders != null) {for (String item :exposeHeaders){ this.addToExposeHeaders(item);}} return (A) this;
  }
  public Boolean hasExposeHeaders() {
    return exposeHeaders != null && !exposeHeaders.isEmpty();
  }
  public String getMaxAge() {
    return this.maxAge;
  }
  public A withMaxAge(String maxAge) {
    this.maxAge=maxAge; return (A) this;
  }
  public Boolean hasMaxAge() {
    return this.maxAge != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CorsPolicyFluentImpl that = (CorsPolicyFluentImpl) o;
    if (!java.util.Objects.equals(allowCredentials, that.allowCredentials)) return false;

    if (!java.util.Objects.equals(allowHeaders, that.allowHeaders)) return false;

    if (!java.util.Objects.equals(allowMethods, that.allowMethods)) return false;

    if (!java.util.Objects.equals(deprecatedAllowOrigin, that.deprecatedAllowOrigin)) return false;

    if (!java.util.Objects.equals(allowOrigins, that.allowOrigins)) return false;

    if (!java.util.Objects.equals(exposeHeaders, that.exposeHeaders)) return false;

    if (!java.util.Objects.equals(maxAge, that.maxAge)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allowCredentials,  allowHeaders,  allowMethods,  deprecatedAllowOrigin,  allowOrigins,  exposeHeaders,  maxAge,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allowCredentials != null) { sb.append("allowCredentials:"); sb.append(allowCredentials + ","); }
    if (allowHeaders != null && !allowHeaders.isEmpty()) { sb.append("allowHeaders:"); sb.append(allowHeaders + ","); }
    if (allowMethods != null && !allowMethods.isEmpty()) { sb.append("allowMethods:"); sb.append(allowMethods + ","); }
    if (deprecatedAllowOrigin != null && !deprecatedAllowOrigin.isEmpty()) { sb.append("deprecatedAllowOrigin:"); sb.append(deprecatedAllowOrigin + ","); }
    if (allowOrigins != null) { sb.append("allowOrigins:"); sb.append(allowOrigins + ","); }
    if (exposeHeaders != null && !exposeHeaders.isEmpty()) { sb.append("exposeHeaders:"); sb.append(exposeHeaders + ","); }
    if (maxAge != null) { sb.append("maxAge:"); sb.append(maxAge); }
    sb.append("}");
    return sb.toString();
  }
  public A withAllowCredentials() {
    return withAllowCredentials(true);
  }
  class AllowOriginsNestedImpl<N> extends StringMatchFluentImpl<CorsPolicyFluentImpl.AllowOriginsNested<N>> implements CorsPolicyFluentImpl.AllowOriginsNested<N>,Nested<N>{
    AllowOriginsNestedImpl(int index,StringMatch item) {
      this.index = index;
      this.builder = new StringMatchBuilder(this, item);
    }
    AllowOriginsNestedImpl() {
      this.index = -1;
      this.builder = new StringMatchBuilder(this);
    }
    StringMatchBuilder builder;
    int index;
    public N and() {
      return (N) CorsPolicyFluentImpl.this.setToAllowOrigins(index,builder.build());
    }
    public N endAllowOrigin() {
      return and();
    }
    
  }
  
}