package io.fabric8.istio.api.meta.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IstioConditionBuilder extends IstioConditionFluentImpl<IstioConditionBuilder> implements VisitableBuilder<IstioCondition,IstioConditionBuilder>{
  public IstioConditionBuilder() {
    this(false);
  }
  public IstioConditionBuilder(Boolean validationEnabled) {
    this(new IstioCondition(), validationEnabled);
  }
  public IstioConditionBuilder(IstioConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public IstioConditionBuilder(IstioConditionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IstioCondition(), validationEnabled);
  }
  public IstioConditionBuilder(IstioConditionFluent<?> fluent,IstioCondition instance) {
    this(fluent, instance, false);
  }
  public IstioConditionBuilder(IstioConditionFluent<?> fluent,IstioCondition instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLastProbeTime(instance.getLastProbeTime());
      fluent.withLastTransitionTime(instance.getLastTransitionTime());
      fluent.withMessage(instance.getMessage());
      fluent.withReason(instance.getReason());
      fluent.withStatus(instance.getStatus());
      fluent.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IstioConditionBuilder(IstioCondition instance) {
    this(instance,false);
  }
  public IstioConditionBuilder(IstioCondition instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLastProbeTime(instance.getLastProbeTime());
      this.withLastTransitionTime(instance.getLastTransitionTime());
      this.withMessage(instance.getMessage());
      this.withReason(instance.getReason());
      this.withStatus(instance.getStatus());
      this.withType(instance.getType());
    }
    this.validationEnabled = validationEnabled; 
  }
  IstioConditionFluent<?> fluent;
  Boolean validationEnabled;
  public IstioCondition build() {
    IstioCondition buildable = new IstioCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    return buildable;
  }
  
}