package io.fabric8.istio.api.analysis.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AnalysisMessageBaseTypeBuilder extends AnalysisMessageBaseTypeFluentImpl<AnalysisMessageBaseTypeBuilder> implements VisitableBuilder<AnalysisMessageBaseType,AnalysisMessageBaseTypeBuilder>{
  public AnalysisMessageBaseTypeBuilder() {
    this(false);
  }
  public AnalysisMessageBaseTypeBuilder(Boolean validationEnabled) {
    this(new AnalysisMessageBaseType(), validationEnabled);
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseTypeFluent<?> fluent) {
    this(fluent, false);
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseTypeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AnalysisMessageBaseType(), validationEnabled);
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseTypeFluent<?> fluent,AnalysisMessageBaseType instance) {
    this(fluent, instance, false);
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseTypeFluent<?> fluent,AnalysisMessageBaseType instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCode(instance.getCode());
      fluent.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseType instance) {
    this(instance,false);
  }
  public AnalysisMessageBaseTypeBuilder(AnalysisMessageBaseType instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCode(instance.getCode());
      this.withName(instance.getName());
    }
    this.validationEnabled = validationEnabled; 
  }
  AnalysisMessageBaseTypeFluent<?> fluent;
  Boolean validationEnabled;
  public AnalysisMessageBaseType build() {
    AnalysisMessageBaseType buildable = new AnalysisMessageBaseType(fluent.getCode(),fluent.getName());
    return buildable;
  }
  
}