package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class HTTPMatchRequestFluentImpl<A extends HTTPMatchRequestFluent<A>> extends BaseFluent<A> implements HTTPMatchRequestFluent<A>{
  public HTTPMatchRequestFluentImpl() {
  }
  public HTTPMatchRequestFluentImpl(HTTPMatchRequest instance) {
    this.withAuthority(instance.getAuthority()); 
    this.withGateways(instance.getGateways()); 
    this.withHeaders(instance.getHeaders()); 
    this.withIgnoreUriCase(instance.getIgnoreUriCase()); 
    this.withMethod(instance.getMethod()); 
    this.withName(instance.getName()); 
    this.withPort(instance.getPort()); 
    this.withQueryParams(instance.getQueryParams()); 
    this.withScheme(instance.getScheme()); 
    this.withSourceLabels(instance.getSourceLabels()); 
    this.withSourceNamespace(instance.getSourceNamespace()); 
    this.withUri(instance.getUri()); 
    this.withWithoutHeaders(instance.getWithoutHeaders()); 
  }
  private StringMatchBuilder authority;
  private List<String> gateways = new ArrayList<String>();
  private Map<String,StringMatch> headers;
  private Boolean ignoreUriCase;
  private StringMatchBuilder method;
  private String name;
  private Integer port;
  private Map<String,StringMatch> queryParams;
  private StringMatchBuilder scheme;
  private Map<String,String> sourceLabels;
  private String sourceNamespace;
  private StringMatchBuilder uri;
  private Map<String,StringMatch> withoutHeaders;
  
  /**
   * This method has been deprecated, please use method buildAuthority instead.
   * @return The buildable object.
   */
  @Deprecated
  public StringMatch getAuthority() {
    return this.authority!=null ?this.authority.build():null;
  }
  public StringMatch buildAuthority() {
    return this.authority!=null ?this.authority.build():null;
  }
  public A withAuthority(StringMatch authority) {
    _visitables.get("authority").remove(this.authority);
    if (authority!=null){ this.authority= new StringMatchBuilder(authority); _visitables.get("authority").add(this.authority);} else { this.authority = null; _visitables.get("authority").remove(this.authority); } return (A) this;
  }
  public Boolean hasAuthority() {
    return this.authority != null;
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthority() {
    return new HTTPMatchRequestFluentImpl.AuthorityNestedImpl();
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> withNewAuthorityLike(StringMatch item) {
    return new HTTPMatchRequestFluentImpl.AuthorityNestedImpl(item);
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> editAuthority() {
    return withNewAuthorityLike(getAuthority());
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthority() {
    return withNewAuthorityLike(getAuthority() != null ? getAuthority(): new StringMatchBuilder().build());
  }
  public HTTPMatchRequestFluent.AuthorityNested<A> editOrNewAuthorityLike(StringMatch item) {
    return withNewAuthorityLike(getAuthority() != null ? getAuthority(): item);
  }
  public A addToGateways(Integer index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.add(index, item);
    return (A)this;
  }
  public A setToGateways(Integer index,String item) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    this.gateways.set(index, item); return (A)this;
  }
  public A addToGateways(java.lang.String... items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A addAllToGateways(Collection<String> items) {
    if (this.gateways == null) {this.gateways = new ArrayList<String>();}
    for (String item : items) {this.gateways.add(item);} return (A)this;
  }
  public A removeFromGateways(java.lang.String... items) {
    for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public A removeAllFromGateways(Collection<String> items) {
    for (String item : items) {if (this.gateways!= null){ this.gateways.remove(item);}} return (A)this;
  }
  public List<String> getGateways() {
    return this.gateways;
  }
  public String getGateway(Integer index) {
    return this.gateways.get(index);
  }
  public String getFirstGateway() {
    return this.gateways.get(0);
  }
  public String getLastGateway() {
    return this.gateways.get(gateways.size() - 1);
  }
  public String getMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGateway(Predicate<String> predicate) {
    for (String item: gateways) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGateways(List<String> gateways) {
    if (gateways != null) {this.gateways = new ArrayList(); for (String item : gateways){this.addToGateways(item);}} else { this.gateways = null;} return (A) this;
  }
  public A withGateways(java.lang.String... gateways) {
    if (this.gateways != null) {this.gateways.clear();}
    if (gateways != null) {for (String item :gateways){ this.addToGateways(item);}} return (A) this;
  }
  public Boolean hasGateways() {
    return gateways != null && !gateways.isEmpty();
  }
  public A addToHeaders(String key,StringMatch value) {
    if(this.headers == null && key != null && value != null) { this.headers = new LinkedHashMap(); }
    if(key != null && value != null) {this.headers.put(key, value);} return (A)this;
  }
  public A addToHeaders(Map<String,StringMatch> map) {
    if(this.headers == null && map != null) { this.headers = new LinkedHashMap(); }
    if(map != null) { this.headers.putAll(map);} return (A)this;
  }
  public A removeFromHeaders(String key) {
    if(this.headers == null) { return (A) this; }
    if(key != null && this.headers != null) {this.headers.remove(key);} return (A)this;
  }
  public A removeFromHeaders(Map<String,StringMatch> map) {
    if(this.headers == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.headers != null){this.headers.remove(key);}}} return (A)this;
  }
  public Map<String,StringMatch> getHeaders() {
    return this.headers;
  }
  public <K,V>A withHeaders(Map<String,StringMatch> headers) {
    if (headers == null) { this.headers =  null;} else {this.headers = new LinkedHashMap(headers);} return (A) this;
  }
  public Boolean hasHeaders() {
    return this.headers != null;
  }
  public Boolean getIgnoreUriCase() {
    return this.ignoreUriCase;
  }
  public A withIgnoreUriCase(Boolean ignoreUriCase) {
    this.ignoreUriCase=ignoreUriCase; return (A) this;
  }
  public Boolean hasIgnoreUriCase() {
    return this.ignoreUriCase != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMethod instead.
   * @return The buildable object.
   */
  @Deprecated
  public StringMatch getMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public StringMatch buildMethod() {
    return this.method!=null ?this.method.build():null;
  }
  public A withMethod(StringMatch method) {
    _visitables.get("method").remove(this.method);
    if (method!=null){ this.method= new StringMatchBuilder(method); _visitables.get("method").add(this.method);} else { this.method = null; _visitables.get("method").remove(this.method); } return (A) this;
  }
  public Boolean hasMethod() {
    return this.method != null;
  }
  public HTTPMatchRequestFluent.MethodNested<A> withNewMethod() {
    return new HTTPMatchRequestFluentImpl.MethodNestedImpl();
  }
  public HTTPMatchRequestFluent.MethodNested<A> withNewMethodLike(StringMatch item) {
    return new HTTPMatchRequestFluentImpl.MethodNestedImpl(item);
  }
  public HTTPMatchRequestFluent.MethodNested<A> editMethod() {
    return withNewMethodLike(getMethod());
  }
  public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethod() {
    return withNewMethodLike(getMethod() != null ? getMethod(): new StringMatchBuilder().build());
  }
  public HTTPMatchRequestFluent.MethodNested<A> editOrNewMethodLike(StringMatch item) {
    return withNewMethodLike(getMethod() != null ? getMethod(): item);
  }
  public String getName() {
    return this.name;
  }
  public A withName(String name) {
    this.name=name; return (A) this;
  }
  public Boolean hasName() {
    return this.name != null;
  }
  public Integer getPort() {
    return this.port;
  }
  public A withPort(Integer port) {
    this.port=port; return (A) this;
  }
  public Boolean hasPort() {
    return this.port != null;
  }
  public A addToQueryParams(String key,StringMatch value) {
    if(this.queryParams == null && key != null && value != null) { this.queryParams = new LinkedHashMap(); }
    if(key != null && value != null) {this.queryParams.put(key, value);} return (A)this;
  }
  public A addToQueryParams(Map<String,StringMatch> map) {
    if(this.queryParams == null && map != null) { this.queryParams = new LinkedHashMap(); }
    if(map != null) { this.queryParams.putAll(map);} return (A)this;
  }
  public A removeFromQueryParams(String key) {
    if(this.queryParams == null) { return (A) this; }
    if(key != null && this.queryParams != null) {this.queryParams.remove(key);} return (A)this;
  }
  public A removeFromQueryParams(Map<String,StringMatch> map) {
    if(this.queryParams == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.queryParams != null){this.queryParams.remove(key);}}} return (A)this;
  }
  public Map<String,StringMatch> getQueryParams() {
    return this.queryParams;
  }
  public <K,V>A withQueryParams(Map<String,StringMatch> queryParams) {
    if (queryParams == null) { this.queryParams =  null;} else {this.queryParams = new LinkedHashMap(queryParams);} return (A) this;
  }
  public Boolean hasQueryParams() {
    return this.queryParams != null;
  }
  
  /**
   * This method has been deprecated, please use method buildScheme instead.
   * @return The buildable object.
   */
  @Deprecated
  public StringMatch getScheme() {
    return this.scheme!=null ?this.scheme.build():null;
  }
  public StringMatch buildScheme() {
    return this.scheme!=null ?this.scheme.build():null;
  }
  public A withScheme(StringMatch scheme) {
    _visitables.get("scheme").remove(this.scheme);
    if (scheme!=null){ this.scheme= new StringMatchBuilder(scheme); _visitables.get("scheme").add(this.scheme);} else { this.scheme = null; _visitables.get("scheme").remove(this.scheme); } return (A) this;
  }
  public Boolean hasScheme() {
    return this.scheme != null;
  }
  public HTTPMatchRequestFluent.SchemeNested<A> withNewScheme() {
    return new HTTPMatchRequestFluentImpl.SchemeNestedImpl();
  }
  public HTTPMatchRequestFluent.SchemeNested<A> withNewSchemeLike(StringMatch item) {
    return new HTTPMatchRequestFluentImpl.SchemeNestedImpl(item);
  }
  public HTTPMatchRequestFluent.SchemeNested<A> editScheme() {
    return withNewSchemeLike(getScheme());
  }
  public HTTPMatchRequestFluent.SchemeNested<A> editOrNewScheme() {
    return withNewSchemeLike(getScheme() != null ? getScheme(): new StringMatchBuilder().build());
  }
  public HTTPMatchRequestFluent.SchemeNested<A> editOrNewSchemeLike(StringMatch item) {
    return withNewSchemeLike(getScheme() != null ? getScheme(): item);
  }
  public A addToSourceLabels(String key,String value) {
    if(this.sourceLabels == null && key != null && value != null) { this.sourceLabels = new LinkedHashMap(); }
    if(key != null && value != null) {this.sourceLabels.put(key, value);} return (A)this;
  }
  public A addToSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null && map != null) { this.sourceLabels = new LinkedHashMap(); }
    if(map != null) { this.sourceLabels.putAll(map);} return (A)this;
  }
  public A removeFromSourceLabels(String key) {
    if(this.sourceLabels == null) { return (A) this; }
    if(key != null && this.sourceLabels != null) {this.sourceLabels.remove(key);} return (A)this;
  }
  public A removeFromSourceLabels(Map<String,String> map) {
    if(this.sourceLabels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.sourceLabels != null){this.sourceLabels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSourceLabels() {
    return this.sourceLabels;
  }
  public <K,V>A withSourceLabels(Map<String,String> sourceLabels) {
    if (sourceLabels == null) { this.sourceLabels =  null;} else {this.sourceLabels = new LinkedHashMap(sourceLabels);} return (A) this;
  }
  public Boolean hasSourceLabels() {
    return this.sourceLabels != null;
  }
  public String getSourceNamespace() {
    return this.sourceNamespace;
  }
  public A withSourceNamespace(String sourceNamespace) {
    this.sourceNamespace=sourceNamespace; return (A) this;
  }
  public Boolean hasSourceNamespace() {
    return this.sourceNamespace != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUri instead.
   * @return The buildable object.
   */
  @Deprecated
  public StringMatch getUri() {
    return this.uri!=null ?this.uri.build():null;
  }
  public StringMatch buildUri() {
    return this.uri!=null ?this.uri.build():null;
  }
  public A withUri(StringMatch uri) {
    _visitables.get("uri").remove(this.uri);
    if (uri!=null){ this.uri= new StringMatchBuilder(uri); _visitables.get("uri").add(this.uri);} else { this.uri = null; _visitables.get("uri").remove(this.uri); } return (A) this;
  }
  public Boolean hasUri() {
    return this.uri != null;
  }
  public HTTPMatchRequestFluent.UriNested<A> withNewUri() {
    return new HTTPMatchRequestFluentImpl.UriNestedImpl();
  }
  public HTTPMatchRequestFluent.UriNested<A> withNewUriLike(StringMatch item) {
    return new HTTPMatchRequestFluentImpl.UriNestedImpl(item);
  }
  public HTTPMatchRequestFluent.UriNested<A> editUri() {
    return withNewUriLike(getUri());
  }
  public HTTPMatchRequestFluent.UriNested<A> editOrNewUri() {
    return withNewUriLike(getUri() != null ? getUri(): new StringMatchBuilder().build());
  }
  public HTTPMatchRequestFluent.UriNested<A> editOrNewUriLike(StringMatch item) {
    return withNewUriLike(getUri() != null ? getUri(): item);
  }
  public A addToWithoutHeaders(String key,StringMatch value) {
    if(this.withoutHeaders == null && key != null && value != null) { this.withoutHeaders = new LinkedHashMap(); }
    if(key != null && value != null) {this.withoutHeaders.put(key, value);} return (A)this;
  }
  public A addToWithoutHeaders(Map<String,StringMatch> map) {
    if(this.withoutHeaders == null && map != null) { this.withoutHeaders = new LinkedHashMap(); }
    if(map != null) { this.withoutHeaders.putAll(map);} return (A)this;
  }
  public A removeFromWithoutHeaders(String key) {
    if(this.withoutHeaders == null) { return (A) this; }
    if(key != null && this.withoutHeaders != null) {this.withoutHeaders.remove(key);} return (A)this;
  }
  public A removeFromWithoutHeaders(Map<String,StringMatch> map) {
    if(this.withoutHeaders == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.withoutHeaders != null){this.withoutHeaders.remove(key);}}} return (A)this;
  }
  public Map<String,StringMatch> getWithoutHeaders() {
    return this.withoutHeaders;
  }
  public <K,V>A withWithoutHeaders(Map<String,StringMatch> withoutHeaders) {
    if (withoutHeaders == null) { this.withoutHeaders =  null;} else {this.withoutHeaders = new LinkedHashMap(withoutHeaders);} return (A) this;
  }
  public Boolean hasWithoutHeaders() {
    return this.withoutHeaders != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    HTTPMatchRequestFluentImpl that = (HTTPMatchRequestFluentImpl) o;
    if (authority != null ? !authority.equals(that.authority) :that.authority != null) return false;
    if (gateways != null ? !gateways.equals(that.gateways) :that.gateways != null) return false;
    if (headers != null ? !headers.equals(that.headers) :that.headers != null) return false;
    if (ignoreUriCase != null ? !ignoreUriCase.equals(that.ignoreUriCase) :that.ignoreUriCase != null) return false;
    if (method != null ? !method.equals(that.method) :that.method != null) return false;
    if (name != null ? !name.equals(that.name) :that.name != null) return false;
    if (port != null ? !port.equals(that.port) :that.port != null) return false;
    if (queryParams != null ? !queryParams.equals(that.queryParams) :that.queryParams != null) return false;
    if (scheme != null ? !scheme.equals(that.scheme) :that.scheme != null) return false;
    if (sourceLabels != null ? !sourceLabels.equals(that.sourceLabels) :that.sourceLabels != null) return false;
    if (sourceNamespace != null ? !sourceNamespace.equals(that.sourceNamespace) :that.sourceNamespace != null) return false;
    if (uri != null ? !uri.equals(that.uri) :that.uri != null) return false;
    if (withoutHeaders != null ? !withoutHeaders.equals(that.withoutHeaders) :that.withoutHeaders != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(authority,  gateways,  headers,  ignoreUriCase,  method,  name,  port,  queryParams,  scheme,  sourceLabels,  sourceNamespace,  uri,  withoutHeaders,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authority != null) { sb.append("authority:"); sb.append(authority + ","); }
    if (gateways != null && !gateways.isEmpty()) { sb.append("gateways:"); sb.append(gateways + ","); }
    if (headers != null && !headers.isEmpty()) { sb.append("headers:"); sb.append(headers + ","); }
    if (ignoreUriCase != null) { sb.append("ignoreUriCase:"); sb.append(ignoreUriCase + ","); }
    if (method != null) { sb.append("method:"); sb.append(method + ","); }
    if (name != null) { sb.append("name:"); sb.append(name + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (queryParams != null && !queryParams.isEmpty()) { sb.append("queryParams:"); sb.append(queryParams + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (sourceLabels != null && !sourceLabels.isEmpty()) { sb.append("sourceLabels:"); sb.append(sourceLabels + ","); }
    if (sourceNamespace != null) { sb.append("sourceNamespace:"); sb.append(sourceNamespace + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (withoutHeaders != null && !withoutHeaders.isEmpty()) { sb.append("withoutHeaders:"); sb.append(withoutHeaders); }
    sb.append("}");
    return sb.toString();
  }
  public A withIgnoreUriCase() {
    return withIgnoreUriCase(true);
  }
  class AuthorityNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.AuthorityNested<N>> implements HTTPMatchRequestFluent.AuthorityNested<N>,Nested<N>{
    AuthorityNestedImpl(StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    AuthorityNestedImpl() {
      this.builder = new StringMatchBuilder(this);
    }
    StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withAuthority(builder.build());
    }
    public N endAuthority() {
      return and();
    }
    
  }
  class MethodNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.MethodNested<N>> implements HTTPMatchRequestFluent.MethodNested<N>,Nested<N>{
    MethodNestedImpl(StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    MethodNestedImpl() {
      this.builder = new StringMatchBuilder(this);
    }
    StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withMethod(builder.build());
    }
    public N endMethod() {
      return and();
    }
    
  }
  class SchemeNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.SchemeNested<N>> implements HTTPMatchRequestFluent.SchemeNested<N>,Nested<N>{
    SchemeNestedImpl(StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    SchemeNestedImpl() {
      this.builder = new StringMatchBuilder(this);
    }
    StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withScheme(builder.build());
    }
    public N endScheme() {
      return and();
    }
    
  }
  class UriNestedImpl<N> extends StringMatchFluentImpl<HTTPMatchRequestFluent.UriNested<N>> implements HTTPMatchRequestFluent.UriNested<N>,Nested<N>{
    UriNestedImpl(StringMatch item) {
      this.builder = new StringMatchBuilder(this, item);
    }
    UriNestedImpl() {
      this.builder = new StringMatchBuilder(this);
    }
    StringMatchBuilder builder;
    public N and() {
      return (N) HTTPMatchRequestFluentImpl.this.withUri(builder.build());
    }
    public N endUri() {
      return and();
    }
    
  }
  
}