package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPHealthCheckConfigBuilder extends HTTPHealthCheckConfigFluentImpl<HTTPHealthCheckConfigBuilder> implements VisitableBuilder<HTTPHealthCheckConfig,HTTPHealthCheckConfigBuilder>{
  public HTTPHealthCheckConfigBuilder() {
    this(false);
  }
  public HTTPHealthCheckConfigBuilder(Boolean validationEnabled) {
    this(new HTTPHealthCheckConfig(), validationEnabled);
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfigFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfigFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPHealthCheckConfig(), validationEnabled);
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfigFluent<?> fluent,HTTPHealthCheckConfig instance) {
    this(fluent, instance, false);
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfigFluent<?> fluent,HTTPHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHost(instance.getHost()); 
    fluent.withHttpHeaders(instance.getHttpHeaders()); 
    fluent.withPath(instance.getPath()); 
    fluent.withPort(instance.getPort()); 
    fluent.withScheme(instance.getScheme()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfig instance) {
    this(instance,false);
  }
  public HTTPHealthCheckConfigBuilder(HTTPHealthCheckConfig instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHost(instance.getHost()); 
    this.withHttpHeaders(instance.getHttpHeaders()); 
    this.withPath(instance.getPath()); 
    this.withPort(instance.getPort()); 
    this.withScheme(instance.getScheme()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPHealthCheckConfigFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPHealthCheckConfig build() {
    HTTPHealthCheckConfig buildable = new HTTPHealthCheckConfig(fluent.getHost(),fluent.getHttpHeaders(),fluent.getPath(),fluent.getPort(),fluent.getScheme());
    return buildable;
  }
  
}