package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConnectionPoolSettingsBuilder extends ConnectionPoolSettingsFluentImpl<ConnectionPoolSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettings,ConnectionPoolSettingsBuilder>{
  public ConnectionPoolSettingsBuilder() {
    this(false);
  }
  public ConnectionPoolSettingsBuilder(Boolean validationEnabled) {
    this(new ConnectionPoolSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConnectionPoolSettings(), validationEnabled);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance) {
    this(fluent, instance, false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHttp(instance.getHttp()); 
    fluent.withTcp(instance.getTcp()); 
    this.validationEnabled = validationEnabled; 
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance) {
    this(instance,false);
  }
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHttp(instance.getHttp()); 
    this.withTcp(instance.getTcp()); 
    this.validationEnabled = validationEnabled; 
  }
  ConnectionPoolSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public ConnectionPoolSettings build() {
    ConnectionPoolSettings buildable = new ConnectionPoolSettings(fluent.getHttp(),fluent.getTcp());
    return buildable;
  }
  
}