package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadEntrySpecBuilder extends WorkloadEntrySpecFluentImpl<WorkloadEntrySpecBuilder> implements VisitableBuilder<WorkloadEntrySpec,WorkloadEntrySpecBuilder>{
  public WorkloadEntrySpecBuilder() {
    this(false);
  }
  public WorkloadEntrySpecBuilder(Boolean validationEnabled) {
    this(new WorkloadEntrySpec(), validationEnabled);
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadEntrySpec(), validationEnabled);
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent,WorkloadEntrySpec instance) {
    this(fluent, instance, false);
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpecFluent<?> fluent,WorkloadEntrySpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAddress(instance.getAddress()); 
    fluent.withLabels(instance.getLabels()); 
    fluent.withLocality(instance.getLocality()); 
    fluent.withNetwork(instance.getNetwork()); 
    fluent.withPorts(instance.getPorts()); 
    fluent.withServiceAccount(instance.getServiceAccount()); 
    fluent.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpec instance) {
    this(instance,false);
  }
  public WorkloadEntrySpecBuilder(WorkloadEntrySpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAddress(instance.getAddress()); 
    this.withLabels(instance.getLabels()); 
    this.withLocality(instance.getLocality()); 
    this.withNetwork(instance.getNetwork()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withWeight(instance.getWeight()); 
    this.validationEnabled = validationEnabled; 
  }
  WorkloadEntrySpecFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadEntrySpec build() {
    WorkloadEntrySpec buildable = new WorkloadEntrySpec(fluent.getAddress(),fluent.getLabels(),fluent.getLocality(),fluent.getNetwork(),fluent.getPorts(),fluent.getServiceAccount(),fluent.getWeight());
    return buildable;
  }
  
}