package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class VirtualServiceListBuilder extends VirtualServiceListFluentImpl<VirtualServiceListBuilder> implements VisitableBuilder<VirtualServiceList,VirtualServiceListBuilder>{
  public VirtualServiceListBuilder() {
    this(false);
  }
  public VirtualServiceListBuilder(Boolean validationEnabled) {
    this(new VirtualServiceList(), validationEnabled);
  }
  public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent) {
    this(fluent, false);
  }
  public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new VirtualServiceList(), validationEnabled);
  }
  public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,VirtualServiceList instance) {
    this(fluent, instance, false);
  }
  public VirtualServiceListBuilder(VirtualServiceListFluent<?> fluent,VirtualServiceList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public VirtualServiceListBuilder(VirtualServiceList instance) {
    this(instance,false);
  }
  public VirtualServiceListBuilder(VirtualServiceList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  VirtualServiceListFluent<?> fluent;
  Boolean validationEnabled;
  public VirtualServiceList build() {
    VirtualServiceList buildable = new VirtualServiceList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}