package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewaySpecFluentImpl<A extends GatewaySpecFluent<A>> extends BaseFluent<A> implements GatewaySpecFluent<A>{
  public GatewaySpecFluentImpl() {
  }
  public GatewaySpecFluentImpl(GatewaySpec instance) {
    this.withSelector(instance.getSelector()); 
    this.withServers(instance.getServers()); 
  }
  private Map<String,String> selector;
  private ArrayList<ServerBuilder> servers = new ArrayList<ServerBuilder>();
  public A addToSelector(String key,String value) {
    if(this.selector == null && key != null && value != null) { this.selector = new LinkedHashMap(); }
    if(key != null && value != null) {this.selector.put(key, value);} return (A)this;
  }
  public A addToSelector(Map<String,String> map) {
    if(this.selector == null && map != null) { this.selector = new LinkedHashMap(); }
    if(map != null) { this.selector.putAll(map);} return (A)this;
  }
  public A removeFromSelector(String key) {
    if(this.selector == null) { return (A) this; }
    if(key != null && this.selector != null) {this.selector.remove(key);} return (A)this;
  }
  public A removeFromSelector(Map<String,String> map) {
    if(this.selector == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.selector != null){this.selector.remove(key);}}} return (A)this;
  }
  public Map<String,String> getSelector() {
    return this.selector;
  }
  public <K,V>A withSelector(Map<String,String> selector) {
    if (selector == null) { this.selector =  null;} else {this.selector = new LinkedHashMap(selector);} return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public A addToServers(Integer index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(index >= 0 ? index : _visitables.get("servers").size(), builder);this.servers.add(index >= 0 ? index : servers.size(), builder); return (A)this;
  }
  public A setToServers(Integer index,Server item) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    ServerBuilder builder = new ServerBuilder(item);
    if (index < 0 || index >= _visitables.get("servers").size()) { _visitables.get("servers").add(builder); } else { _visitables.get("servers").set(index, builder);}
    if (index < 0 || index >= servers.size()) { servers.add(builder); } else { servers.set(index, builder);}
     return (A)this;
  }
  public A addToServers(io.fabric8.istio.api.networking.v1alpha3.Server... items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A addAllToServers(Collection<Server> items) {
    if (this.servers == null) {this.servers = new ArrayList<ServerBuilder>();}
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").add(builder);this.servers.add(builder);} return (A)this;
  }
  public A removeFromServers(io.fabric8.istio.api.networking.v1alpha3.Server... items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeAllFromServers(Collection<Server> items) {
    for (Server item : items) {ServerBuilder builder = new ServerBuilder(item);_visitables.get("servers").remove(builder);if (this.servers != null) {this.servers.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromServers(Predicate<ServerBuilder> predicate) {
    if (servers == null) return (A) this;
    final Iterator<ServerBuilder> each = servers.iterator();
    final List visitables = _visitables.get("servers");
    while (each.hasNext()) {
      ServerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildServers instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Server> getServers() {
    return servers != null ? build(servers) : null;
  }
  public List<Server> buildServers() {
    return servers != null ? build(servers) : null;
  }
  public Server buildServer(Integer index) {
    return this.servers.get(index).build();
  }
  public Server buildFirstServer() {
    return this.servers.get(0).build();
  }
  public Server buildLastServer() {
    return this.servers.get(servers.size() - 1).build();
  }
  public Server buildMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingServer(Predicate<ServerBuilder> predicate) {
    for (ServerBuilder item: servers) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withServers(List<Server> servers) {
    if (this.servers != null) { _visitables.get("servers").removeAll(this.servers);}
    if (servers != null) {this.servers = new ArrayList(); for (Server item : servers){this.addToServers(item);}} else { this.servers = null;} return (A) this;
  }
  public A withServers(io.fabric8.istio.api.networking.v1alpha3.Server... servers) {
    if (this.servers != null) {this.servers.clear();}
    if (servers != null) {for (Server item :servers){ this.addToServers(item);}} return (A) this;
  }
  public Boolean hasServers() {
    return servers != null && !servers.isEmpty();
  }
  public GatewaySpecFluent.ServersNested<A> addNewServer() {
    return new GatewaySpecFluentImpl.ServersNestedImpl();
  }
  public GatewaySpecFluent.ServersNested<A> addNewServerLike(Server item) {
    return new GatewaySpecFluentImpl.ServersNestedImpl(-1, item);
  }
  public GatewaySpecFluent.ServersNested<A> setNewServerLike(Integer index,Server item) {
    return new GatewaySpecFluentImpl.ServersNestedImpl(index, item);
  }
  public GatewaySpecFluent.ServersNested<A> editServer(Integer index) {
    if (servers.size() <= index) throw new RuntimeException("Can't edit servers. Index exceeds size.");
    return setNewServerLike(index, buildServer(index));
  }
  public GatewaySpecFluent.ServersNested<A> editFirstServer() {
    if (servers.size() == 0) throw new RuntimeException("Can't edit first servers. The list is empty.");
    return setNewServerLike(0, buildServer(0));
  }
  public GatewaySpecFluent.ServersNested<A> editLastServer() {
    int index = servers.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last servers. The list is empty.");
    return setNewServerLike(index, buildServer(index));
  }
  public GatewaySpecFluent.ServersNested<A> editMatchingServer(Predicate<ServerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<servers.size();i++) { 
    if (predicate.test(servers.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching servers. No match found.");
    return setNewServerLike(index, buildServer(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    GatewaySpecFluentImpl that = (GatewaySpecFluentImpl) o;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (servers != null ? !servers.equals(that.servers) :that.servers != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(selector,  servers,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (selector != null && !selector.isEmpty()) { sb.append("selector:"); sb.append(selector + ","); }
    if (servers != null && !servers.isEmpty()) { sb.append("servers:"); sb.append(servers); }
    sb.append("}");
    return sb.toString();
  }
  class ServersNestedImpl<N> extends ServerFluentImpl<GatewaySpecFluent.ServersNested<N>> implements GatewaySpecFluent.ServersNested<N>,Nested<N>{
    ServersNestedImpl(Integer index,Server item) {
      this.index = index;
      this.builder = new ServerBuilder(this, item);
    }
    ServersNestedImpl() {
      this.index = -1;
      this.builder = new ServerBuilder(this);
    }
    ServerBuilder builder;
    Integer index;
    public N and() {
      return (N) GatewaySpecFluentImpl.this.setToServers(index,builder.build());
    }
    public N endServer() {
      return and();
    }
    
  }
  
}