package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class EnvoyFilterSpecBuilder extends EnvoyFilterSpecFluentImpl<EnvoyFilterSpecBuilder> implements VisitableBuilder<EnvoyFilterSpec,EnvoyFilterSpecBuilder>{
  public EnvoyFilterSpecBuilder() {
    this(false);
  }
  public EnvoyFilterSpecBuilder(Boolean validationEnabled) {
    this(new EnvoyFilterSpec(), validationEnabled);
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new EnvoyFilterSpec(), validationEnabled);
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,EnvoyFilterSpec instance) {
    this(fluent, instance, false);
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpecFluent<?> fluent,EnvoyFilterSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConfigPatches(instance.getConfigPatches()); 
    fluent.withPriority(instance.getPriority()); 
    fluent.withWorkloadSelector(instance.getWorkloadSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpec instance) {
    this(instance,false);
  }
  public EnvoyFilterSpecBuilder(EnvoyFilterSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConfigPatches(instance.getConfigPatches()); 
    this.withPriority(instance.getPriority()); 
    this.withWorkloadSelector(instance.getWorkloadSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  EnvoyFilterSpecFluent<?> fluent;
  Boolean validationEnabled;
  public EnvoyFilterSpec build() {
    EnvoyFilterSpec buildable = new EnvoyFilterSpec(fluent.getConfigPatches(),fluent.getPriority(),fluent.getWorkloadSelector());
    return buildable;
  }
  
}