package io.fabric8.istio.api.internal.protobuf.types;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValueBuilder extends ValueFluentImpl<ValueBuilder> implements VisitableBuilder<Value,ValueBuilder>{
  public ValueBuilder() {
    this(false);
  }
  public ValueBuilder(Boolean validationEnabled) {
    this(new Value(), validationEnabled);
  }
  public ValueBuilder(ValueFluent<?> fluent) {
    this(fluent, false);
  }
  public ValueBuilder(ValueFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Value(), validationEnabled);
  }
  public ValueBuilder(ValueFluent<?> fluent,Value instance) {
    this(fluent, instance, false);
  }
  public ValueBuilder(ValueFluent<?> fluent,Value instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withKind(instance.getKind()); 
    this.validationEnabled = validationEnabled; 
  }
  public ValueBuilder(Value instance) {
    this(instance,false);
  }
  public ValueBuilder(Value instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withKind(instance.getKind()); 
    this.validationEnabled = validationEnabled; 
  }
  ValueFluent<?> fluent;
  Boolean validationEnabled;
  public Value build() {
    Value buildable = new Value(fluent.getKind());
    return buildable;
  }
  
}