/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.istio.api.networking.v1alpha3.WorkloadGroup;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadGroupBuilder;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadGroupFluentImpl;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadGroupList;
import io.fabric8.istio.api.networking.v1alpha3.WorkloadGroupListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class WorkloadGroupListFluentImpl<A extends WorkloadGroupListFluent<A>>
extends BaseFluent<A>
implements WorkloadGroupListFluent<A> {
    private String apiVersion;
    private ArrayList<WorkloadGroupBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public WorkloadGroupListFluentImpl() {
    }

    public WorkloadGroupListFluentImpl(WorkloadGroupList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, WorkloadGroup item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, WorkloadGroup item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(WorkloadGroup ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (WorkloadGroup item : items) {
            WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<WorkloadGroup> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (WorkloadGroup item : items) {
            WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(WorkloadGroup ... items) {
        for (WorkloadGroup item : items) {
            WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<WorkloadGroup> items) {
        for (WorkloadGroup item : items) {
            WorkloadGroupBuilder builder = new WorkloadGroupBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<WorkloadGroupBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<WorkloadGroupBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            WorkloadGroupBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<WorkloadGroup> getItems() {
        return this.items != null ? WorkloadGroupListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<WorkloadGroup> buildItems() {
        return this.items != null ? WorkloadGroupListFluentImpl.build(this.items) : null;
    }

    @Override
    public WorkloadGroup buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public WorkloadGroup buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public WorkloadGroup buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public WorkloadGroup buildMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
        for (WorkloadGroupBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
        for (WorkloadGroupBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<WorkloadGroup> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (WorkloadGroup item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(WorkloadGroup ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (WorkloadGroup item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> addNewItemLike(WorkloadGroup item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> setNewItemLike(Integer index, WorkloadGroup item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public WorkloadGroupListFluent.ItemsNested<A> editMatchingItem(Predicate<WorkloadGroupBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkloadGroupListFluentImpl that = (WorkloadGroupListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends WorkloadGroupFluentImpl<WorkloadGroupListFluent.ItemsNested<N>>
    implements WorkloadGroupListFluent.ItemsNested<N>,
    Nested<N> {
        WorkloadGroupBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, WorkloadGroup item) {
            this.index = index;
            this.builder = new WorkloadGroupBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new WorkloadGroupBuilder(this);
        }

        @Override
        public N and() {
            return (N)WorkloadGroupListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

