/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1alpha3;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum CaptureMode {
    DEFAULT(0),
    IPTABLES(1),
    NONE(2);

    private final Integer value;
    private static final Map<Integer, CaptureMode> CONSTANTS;
    private static final Map<String, CaptureMode> NAME_CONSTANTS;

    private CaptureMode(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static CaptureMode fromValue(Object value) {
        if (value instanceof String) {
            CaptureMode constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        CaptureMode constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, CaptureMode>();
        NAME_CONSTANTS = new HashMap<String, CaptureMode>();
        for (CaptureMode c : CaptureMode.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (CaptureMode c : CaptureMode.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

