package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SidecarBuilder extends SidecarFluent<SidecarBuilder> implements VisitableBuilder<Sidecar,SidecarBuilder>{
  public SidecarBuilder() {
    this(new Sidecar());
  }
  
  public SidecarBuilder(SidecarFluent<?> fluent) {
    this(fluent, new Sidecar());
  }
  
  public SidecarBuilder(SidecarFluent<?> fluent,Sidecar instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SidecarBuilder(Sidecar instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SidecarFluent<?> fluent;
  
  public Sidecar build() {
    Sidecar buildable = new Sidecar(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}