package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class RouteDestinationFluent<A extends RouteDestinationFluent<A>> extends BaseFluent<A>{
  public RouteDestinationFluent() {
  }
  
  public RouteDestinationFluent(RouteDestination instance) {
    this.copyInstance(instance);
  }
  private DestinationBuilder destination;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(RouteDestination instance) {
    instance = (instance != null ? instance : new RouteDestination());
    if (instance != null) {
          this.withDestination(instance.getDestination());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Destination buildDestination() {
    return this.destination != null ? this.destination.build() : null;
  }
  
  public A withDestination(Destination destination) {
    this._visitables.remove("destination");
    if (destination != null) {
        this.destination = new DestinationBuilder(destination);
        this._visitables.get("destination").add(this.destination);
    } else {
        this.destination = null;
        this._visitables.get("destination").remove(this.destination);
    }
    return (A) this;
  }
  
  public boolean hasDestination() {
    return this.destination != null;
  }
  
  public DestinationNested<A> withNewDestination() {
    return new DestinationNested(null);
  }
  
  public DestinationNested<A> withNewDestinationLike(Destination item) {
    return new DestinationNested(item);
  }
  
  public DestinationNested<A> editDestination() {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(null));
  }
  
  public DestinationNested<A> editOrNewDestination() {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(new DestinationBuilder().build()));
  }
  
  public DestinationNested<A> editOrNewDestinationLike(Destination item) {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(item));
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RouteDestinationFluent that = (RouteDestinationFluent) o;
    if (!java.util.Objects.equals(destination, that.destination)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(destination,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destination != null) { sb.append("destination:"); sb.append(destination + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DestinationNested<N> extends DestinationFluent<DestinationNested<N>> implements Nested<N>{
    DestinationNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) RouteDestinationFluent.this.withDestination(builder.build());
    }
    
    public N endDestination() {
      return and();
    }
    
  
  }

}