package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class LoadBalancerSettingsFluent<A extends LoadBalancerSettingsFluent<A>> extends BaseFluent<A>{
  public LoadBalancerSettingsFluent() {
  }
  
  public LoadBalancerSettingsFluent(LoadBalancerSettings instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsLoadBalancerSettingsLbPolicy,?> lbPolicy;
  private LocalityLoadBalancerSettingBuilder localityLbSetting;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(LoadBalancerSettings instance) {
    instance = (instance != null ? instance : new LoadBalancerSettings());
    if (instance != null) {
          this.withLbPolicy(instance.getLbPolicy());
          this.withLocalityLbSetting(instance.getLocalityLbSetting());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsLoadBalancerSettingsLbPolicy buildLbPolicy() {
    return this.lbPolicy != null ? this.lbPolicy.build() : null;
  }
  
  public A withLbPolicy(IsLoadBalancerSettingsLbPolicy lbPolicy) {
    if (lbPolicy == null) {
        this.lbPolicy = null;
        this._visitables.remove("lbPolicy");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsLoadBalancerSettingsLbPolicy,?> builder = builder(lbPolicy);;
        this._visitables.clear();
        this._visitables.get("lbPolicy").add(builder);
        this.lbPolicy = builder;
        return (A) this;
    }
  }
  
  public boolean hasLbPolicy() {
    return this.lbPolicy != null;
  }
  
  public LoadBalancerSettingsSimpleLbPolicyNested<A> withNewLoadBalancerSettingsSimpleLbPolicy() {
    return new LoadBalancerSettingsSimpleLbPolicyNested(null);
  }
  
  public LoadBalancerSettingsSimpleLbPolicyNested<A> withNewLoadBalancerSettingsSimpleLbPolicyLike(LoadBalancerSettingsSimple item) {
    return new LoadBalancerSettingsSimpleLbPolicyNested(item);
  }
  
  public LoadBalancerSettingsConsistentHashLbPolicyNested<A> withNewLoadBalancerSettingsConsistentHashLbPolicy() {
    return new LoadBalancerSettingsConsistentHashLbPolicyNested(null);
  }
  
  public LoadBalancerSettingsConsistentHashLbPolicyNested<A> withNewLoadBalancerSettingsConsistentHashLbPolicyLike(LoadBalancerSettingsConsistentHash item) {
    return new LoadBalancerSettingsConsistentHashLbPolicyNested(item);
  }
  
  public LocalityLoadBalancerSetting buildLocalityLbSetting() {
    return this.localityLbSetting != null ? this.localityLbSetting.build() : null;
  }
  
  public A withLocalityLbSetting(LocalityLoadBalancerSetting localityLbSetting) {
    this._visitables.remove("localityLbSetting");
    if (localityLbSetting != null) {
        this.localityLbSetting = new LocalityLoadBalancerSettingBuilder(localityLbSetting);
        this._visitables.get("localityLbSetting").add(this.localityLbSetting);
    } else {
        this.localityLbSetting = null;
        this._visitables.get("localityLbSetting").remove(this.localityLbSetting);
    }
    return (A) this;
  }
  
  public boolean hasLocalityLbSetting() {
    return this.localityLbSetting != null;
  }
  
  public LocalityLbSettingNested<A> withNewLocalityLbSetting() {
    return new LocalityLbSettingNested(null);
  }
  
  public LocalityLbSettingNested<A> withNewLocalityLbSettingLike(LocalityLoadBalancerSetting item) {
    return new LocalityLbSettingNested(item);
  }
  
  public LocalityLbSettingNested<A> editLocalityLbSetting() {
    return withNewLocalityLbSettingLike(java.util.Optional.ofNullable(buildLocalityLbSetting()).orElse(null));
  }
  
  public LocalityLbSettingNested<A> editOrNewLocalityLbSetting() {
    return withNewLocalityLbSettingLike(java.util.Optional.ofNullable(buildLocalityLbSetting()).orElse(new LocalityLoadBalancerSettingBuilder().build()));
  }
  
  public LocalityLbSettingNested<A> editOrNewLocalityLbSettingLike(LocalityLoadBalancerSetting item) {
    return withNewLocalityLbSettingLike(java.util.Optional.ofNullable(buildLocalityLbSetting()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    LoadBalancerSettingsFluent that = (LoadBalancerSettingsFluent) o;
    if (!java.util.Objects.equals(lbPolicy, that.lbPolicy)) return false;
    if (!java.util.Objects.equals(localityLbSetting, that.localityLbSetting)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(lbPolicy,  localityLbSetting,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (lbPolicy != null) { sb.append("lbPolicy:"); sb.append(lbPolicy + ","); }
    if (localityLbSetting != null) { sb.append("localityLbSetting:"); sb.append(localityLbSetting + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1alpha3."+"LoadBalancerSettingsSimple": return (VisitableBuilder<T, ?>)new LoadBalancerSettingsSimpleBuilder((LoadBalancerSettingsSimple) item);
    case "io.fabric8.istio.api.networking.v1alpha3."+"LoadBalancerSettingsConsistentHash": return (VisitableBuilder<T, ?>)new LoadBalancerSettingsConsistentHashBuilder((LoadBalancerSettingsConsistentHash) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class LoadBalancerSettingsSimpleLbPolicyNested<N> extends LoadBalancerSettingsSimpleFluent<LoadBalancerSettingsSimpleLbPolicyNested<N>> implements Nested<N>{
    LoadBalancerSettingsSimpleLbPolicyNested(LoadBalancerSettingsSimple item) {
      this.builder = new LoadBalancerSettingsSimpleBuilder(this, item);
    }
    LoadBalancerSettingsSimpleBuilder builder;
    
    public N and() {
      return (N) LoadBalancerSettingsFluent.this.withLbPolicy(builder.build());
    }
    
    public N endLoadBalancerSettingsSimpleLbPolicy() {
      return and();
    }
    
  
  }
  public class LoadBalancerSettingsConsistentHashLbPolicyNested<N> extends LoadBalancerSettingsConsistentHashFluent<LoadBalancerSettingsConsistentHashLbPolicyNested<N>> implements Nested<N>{
    LoadBalancerSettingsConsistentHashLbPolicyNested(LoadBalancerSettingsConsistentHash item) {
      this.builder = new LoadBalancerSettingsConsistentHashBuilder(this, item);
    }
    LoadBalancerSettingsConsistentHashBuilder builder;
    
    public N and() {
      return (N) LoadBalancerSettingsFluent.this.withLbPolicy(builder.build());
    }
    
    public N endLoadBalancerSettingsConsistentHashLbPolicy() {
      return and();
    }
    
  
  }
  public class LocalityLbSettingNested<N> extends LocalityLoadBalancerSettingFluent<LocalityLbSettingNested<N>> implements Nested<N>{
    LocalityLbSettingNested(LocalityLoadBalancerSetting item) {
      this.builder = new LocalityLoadBalancerSettingBuilder(this, item);
    }
    LocalityLoadBalancerSettingBuilder builder;
    
    public N and() {
      return (N) LoadBalancerSettingsFluent.this.withLocalityLbSetting(builder.build());
    }
    
    public N endLocalityLbSetting() {
      return and();
    }
    
  
  }

}