package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IstioIngressListenerBuilder extends IstioIngressListenerFluent<IstioIngressListenerBuilder> implements VisitableBuilder<IstioIngressListener,IstioIngressListenerBuilder>{
  public IstioIngressListenerBuilder() {
    this(new IstioIngressListener());
  }
  
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent) {
    this(fluent, new IstioIngressListener());
  }
  
  public IstioIngressListenerBuilder(IstioIngressListenerFluent<?> fluent,IstioIngressListener instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IstioIngressListenerBuilder(IstioIngressListener instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IstioIngressListenerFluent<?> fluent;
  
  public IstioIngressListener build() {
    IstioIngressListener buildable = new IstioIngressListener(fluent.getBind(),fluent.getCaptureMode(),fluent.getDefaultEndpoint(),fluent.buildPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}