package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class GatewayBuilder extends GatewayFluent<GatewayBuilder> implements VisitableBuilder<Gateway,GatewayBuilder>{
  public GatewayBuilder() {
    this(new Gateway());
  }
  
  public GatewayBuilder(GatewayFluent<?> fluent) {
    this(fluent, new Gateway());
  }
  
  public GatewayBuilder(GatewayFluent<?> fluent,Gateway instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public GatewayBuilder(Gateway instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  GatewayFluent<?> fluent;
  
  public Gateway build() {
    Gateway buildable = new Gateway(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}