package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ClientTLSSettingsFluent<A extends ClientTLSSettingsFluent<A>> extends BaseFluent<A>{
  public ClientTLSSettingsFluent() {
  }
  
  public ClientTLSSettingsFluent(ClientTLSSettings instance) {
    this.copyInstance(instance);
  }
  private String caCertificates;
  private String clientCertificate;
  private String credentialName;
  private Boolean insecureSkipVerify;
  private ClientTLSSettingsTLSmode mode;
  private String privateKey;
  private String sni;
  private List<String> subjectAltNames = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ClientTLSSettings instance) {
    instance = (instance != null ? instance : new ClientTLSSettings());
    if (instance != null) {
          this.withCaCertificates(instance.getCaCertificates());
          this.withClientCertificate(instance.getClientCertificate());
          this.withCredentialName(instance.getCredentialName());
          this.withInsecureSkipVerify(instance.getInsecureSkipVerify());
          this.withMode(instance.getMode());
          this.withPrivateKey(instance.getPrivateKey());
          this.withSni(instance.getSni());
          this.withSubjectAltNames(instance.getSubjectAltNames());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getCaCertificates() {
    return this.caCertificates;
  }
  
  public A withCaCertificates(String caCertificates) {
    this.caCertificates = caCertificates;
    return (A) this;
  }
  
  public boolean hasCaCertificates() {
    return this.caCertificates != null;
  }
  
  public String getClientCertificate() {
    return this.clientCertificate;
  }
  
  public A withClientCertificate(String clientCertificate) {
    this.clientCertificate = clientCertificate;
    return (A) this;
  }
  
  public boolean hasClientCertificate() {
    return this.clientCertificate != null;
  }
  
  public String getCredentialName() {
    return this.credentialName;
  }
  
  public A withCredentialName(String credentialName) {
    this.credentialName = credentialName;
    return (A) this;
  }
  
  public boolean hasCredentialName() {
    return this.credentialName != null;
  }
  
  public Boolean getInsecureSkipVerify() {
    return this.insecureSkipVerify;
  }
  
  public A withInsecureSkipVerify(Boolean insecureSkipVerify) {
    this.insecureSkipVerify = insecureSkipVerify;
    return (A) this;
  }
  
  public boolean hasInsecureSkipVerify() {
    return this.insecureSkipVerify != null;
  }
  
  public ClientTLSSettingsTLSmode getMode() {
    return this.mode;
  }
  
  public A withMode(ClientTLSSettingsTLSmode mode) {
    this.mode = mode;
    return (A) this;
  }
  
  public boolean hasMode() {
    return this.mode != null;
  }
  
  public String getPrivateKey() {
    return this.privateKey;
  }
  
  public A withPrivateKey(String privateKey) {
    this.privateKey = privateKey;
    return (A) this;
  }
  
  public boolean hasPrivateKey() {
    return this.privateKey != null;
  }
  
  public String getSni() {
    return this.sni;
  }
  
  public A withSni(String sni) {
    this.sni = sni;
    return (A) this;
  }
  
  public boolean hasSni() {
    return this.sni != null;
  }
  
  public A addToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  
  public A setToSubjectAltNames(int index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  
  public A addAllToSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  
  public A removeFromSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) return (A)this;
    for (String item : items) { this.subjectAltNames.remove(item);} return (A)this;
  }
  
  public A removeAllFromSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) return (A)this;
    for (String item : items) { this.subjectAltNames.remove(item);} return (A)this;
  }
  
  public List<String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  
  public String getSubjectAltName(int index) {
    return this.subjectAltNames.get(index);
  }
  
  public String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  
  public String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  
  public String getMatchingSubjectAltName(Predicate<String> predicate) {
      for (String item : subjectAltNames) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
      for (String item : subjectAltNames) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSubjectAltNames(List<String> subjectAltNames) {
    if (subjectAltNames != null) {
        this.subjectAltNames = new ArrayList();
        for (String item : subjectAltNames) {
          this.addToSubjectAltNames(item);
        }
    } else {
      this.subjectAltNames = null;
    }
    return (A) this;
  }
  
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {
        this.subjectAltNames.clear();
        _visitables.remove("subjectAltNames");
    }
    if (subjectAltNames != null) {
      for (String item : subjectAltNames) {
        this.addToSubjectAltNames(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSubjectAltNames() {
    return this.subjectAltNames != null && !this.subjectAltNames.isEmpty();
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClientTLSSettingsFluent that = (ClientTLSSettingsFluent) o;
    if (!java.util.Objects.equals(caCertificates, that.caCertificates)) return false;
    if (!java.util.Objects.equals(clientCertificate, that.clientCertificate)) return false;
    if (!java.util.Objects.equals(credentialName, that.credentialName)) return false;
    if (!java.util.Objects.equals(insecureSkipVerify, that.insecureSkipVerify)) return false;
    if (!java.util.Objects.equals(mode, that.mode)) return false;
    if (!java.util.Objects.equals(privateKey, that.privateKey)) return false;
    if (!java.util.Objects.equals(sni, that.sni)) return false;
    if (!java.util.Objects.equals(subjectAltNames, that.subjectAltNames)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(caCertificates,  clientCertificate,  credentialName,  insecureSkipVerify,  mode,  privateKey,  sni,  subjectAltNames,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caCertificates != null) { sb.append("caCertificates:"); sb.append(caCertificates + ","); }
    if (clientCertificate != null) { sb.append("clientCertificate:"); sb.append(clientCertificate + ","); }
    if (credentialName != null) { sb.append("credentialName:"); sb.append(credentialName + ","); }
    if (insecureSkipVerify != null) { sb.append("insecureSkipVerify:"); sb.append(insecureSkipVerify + ","); }
    if (mode != null) { sb.append("mode:"); sb.append(mode + ","); }
    if (privateKey != null) { sb.append("privateKey:"); sb.append(privateKey + ","); }
    if (sni != null) { sb.append("sni:"); sb.append(sni + ","); }
    if (subjectAltNames != null && !subjectAltNames.isEmpty()) { sb.append("subjectAltNames:"); sb.append(subjectAltNames + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withInsecureSkipVerify() {
    return withInsecureSkipVerify(true);
  }
  

}