package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IstioIngressListenerFluent<A extends IstioIngressListenerFluent<A>> extends BaseFluent<A>{
  public IstioIngressListenerFluent() {
  }
  
  public IstioIngressListenerFluent(IstioIngressListener instance) {
    this.copyInstance(instance);
  }
  private String bind;
  private CaptureMode captureMode;
  private String defaultEndpoint;
  private PortBuilder port;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IstioIngressListener instance) {
    instance = (instance != null ? instance : new IstioIngressListener());
    if (instance != null) {
          this.withBind(instance.getBind());
          this.withCaptureMode(instance.getCaptureMode());
          this.withDefaultEndpoint(instance.getDefaultEndpoint());
          this.withPort(instance.getPort());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBind() {
    return this.bind;
  }
  
  public A withBind(String bind) {
    this.bind = bind;
    return (A) this;
  }
  
  public boolean hasBind() {
    return this.bind != null;
  }
  
  public CaptureMode getCaptureMode() {
    return this.captureMode;
  }
  
  public A withCaptureMode(CaptureMode captureMode) {
    this.captureMode = captureMode;
    return (A) this;
  }
  
  public boolean hasCaptureMode() {
    return this.captureMode != null;
  }
  
  public String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  
  public A withDefaultEndpoint(String defaultEndpoint) {
    this.defaultEndpoint = defaultEndpoint;
    return (A) this;
  }
  
  public boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  
  public Port buildPort() {
    return this.port != null ? this.port.build() : null;
  }
  
  public A withPort(Port port) {
    this._visitables.remove("port");
    if (port != null) {
        this.port = new PortBuilder(port);
        this._visitables.get("port").add(this.port);
    } else {
        this.port = null;
        this._visitables.get("port").remove(this.port);
    }
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)withPort(new Port(name, number, protocol, targetPort));
  }
  
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  
  public PortNested<A> withNewPortLike(Port item) {
    return new PortNested(item);
  }
  
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new PortBuilder().build()));
  }
  
  public PortNested<A> editOrNewPortLike(Port item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IstioIngressListenerFluent that = (IstioIngressListenerFluent) o;
    if (!java.util.Objects.equals(bind, that.bind)) return false;
    if (!java.util.Objects.equals(captureMode, that.captureMode)) return false;
    if (!java.util.Objects.equals(defaultEndpoint, that.defaultEndpoint)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bind,  captureMode,  defaultEndpoint,  port,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (captureMode != null) { sb.append("captureMode:"); sb.append(captureMode + ","); }
    if (defaultEndpoint != null) { sb.append("defaultEndpoint:"); sb.append(defaultEndpoint + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class PortNested<N> extends PortFluent<PortNested<N>> implements Nested<N>{
    PortNested(Port item) {
      this.builder = new PortBuilder(this, item);
    }
    PortBuilder builder;
    
    public N and() {
      return (N) IstioIngressListenerFluent.this.withPort(builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }

}