package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IstioEgressListenerBuilder extends IstioEgressListenerFluent<IstioEgressListenerBuilder> implements VisitableBuilder<IstioEgressListener,IstioEgressListenerBuilder>{
  public IstioEgressListenerBuilder() {
    this(new IstioEgressListener());
  }
  
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent) {
    this(fluent, new IstioEgressListener());
  }
  
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent,IstioEgressListener instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IstioEgressListenerBuilder(IstioEgressListener instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IstioEgressListenerFluent<?> fluent;
  
  public IstioEgressListener build() {
    IstioEgressListener buildable = new IstioEgressListener(fluent.getBind(),fluent.getCaptureMode(),fluent.getHosts(),fluent.buildPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}