package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPHealthCheckConfigFluent<A extends HTTPHealthCheckConfigFluent<A>> extends BaseFluent<A>{
  public HTTPHealthCheckConfigFluent() {
  }
  
  public HTTPHealthCheckConfigFluent(HTTPHealthCheckConfig instance) {
    this.copyInstance(instance);
  }
  private String host;
  private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList<HTTPHeaderBuilder>();
  private String path;
  private Integer port;
  private String scheme;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPHealthCheckConfig instance) {
    instance = (instance != null ? instance : new HTTPHealthCheckConfig());
    if (instance != null) {
          this.withHost(instance.getHost());
          this.withHttpHeaders(instance.getHttpHeaders());
          this.withPath(instance.getPath());
          this.withPort(instance.getPort());
          this.withScheme(instance.getScheme());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getHost() {
    return this.host;
  }
  
  public A withHost(String host) {
    this.host = host;
    return (A) this;
  }
  
  public boolean hasHost() {
    return this.host != null;
  }
  
  public A addToHttpHeaders(int index,HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
    if (index < 0 || index >= httpHeaders.size()) { _visitables.get("httpHeaders").add(builder); httpHeaders.add(builder); } else { _visitables.get("httpHeaders").add(index, builder); httpHeaders.add(index, builder);}
    return (A)this;
  }
  
  public A setToHttpHeaders(int index,HTTPHeader item) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
    if (index < 0 || index >= httpHeaders.size()) { _visitables.get("httpHeaders").add(builder); httpHeaders.add(builder); } else { _visitables.get("httpHeaders").set(index, builder); httpHeaders.set(index, builder);}
    return (A)this;
  }
  
  public A addToHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... items) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  
  public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
    if (this.httpHeaders == null) {this.httpHeaders = new ArrayList<HTTPHeaderBuilder>();}
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").add(builder);this.httpHeaders.add(builder);} return (A)this;
  }
  
  public A removeFromHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... items) {
    if (this.httpHeaders == null) return (A)this;
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder); this.httpHeaders.remove(builder);} return (A)this;
  }
  
  public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
    if (this.httpHeaders == null) return (A)this;
    for (HTTPHeader item : items) {HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);_visitables.get("httpHeaders").remove(builder); this.httpHeaders.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
    if (httpHeaders == null) return (A) this;
    final Iterator<HTTPHeaderBuilder> each = httpHeaders.iterator();
    final List visitables = _visitables.get("httpHeaders");
    while (each.hasNext()) {
      HTTPHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<HTTPHeader> buildHttpHeaders() {
    return this.httpHeaders != null ? build(httpHeaders) : null;
  }
  
  public HTTPHeader buildHttpHeader(int index) {
    return this.httpHeaders.get(index).build();
  }
  
  public HTTPHeader buildFirstHttpHeader() {
    return this.httpHeaders.get(0).build();
  }
  
  public HTTPHeader buildLastHttpHeader() {
    return this.httpHeaders.get(httpHeaders.size() - 1).build();
  }
  
  public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
      for (HTTPHeaderBuilder item : httpHeaders) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
      for (HTTPHeaderBuilder item : httpHeaders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
    if (this.httpHeaders != null) {
      this._visitables.get("httpHeaders").clear();
    }
    if (httpHeaders != null) {
        this.httpHeaders = new ArrayList();
        for (HTTPHeader item : httpHeaders) {
          this.addToHttpHeaders(item);
        }
    } else {
      this.httpHeaders = null;
    }
    return (A) this;
  }
  
  public A withHttpHeaders(io.fabric8.istio.api.networking.v1alpha3.HTTPHeader... httpHeaders) {
    if (this.httpHeaders != null) {
        this.httpHeaders.clear();
        _visitables.remove("httpHeaders");
    }
    if (httpHeaders != null) {
      for (HTTPHeader item : httpHeaders) {
        this.addToHttpHeaders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasHttpHeaders() {
    return this.httpHeaders != null && !this.httpHeaders.isEmpty();
  }
  
  public A addNewHttpHeader(String name,String value) {
    return (A)addToHttpHeaders(new HTTPHeader(name, value));
  }
  
  public HttpHeadersNested<A> addNewHttpHeader() {
    return new HttpHeadersNested(-1, null);
  }
  
  public HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
    return new HttpHeadersNested(-1, item);
  }
  
  public HttpHeadersNested<A> setNewHttpHeaderLike(int index,HTTPHeader item) {
    return new HttpHeadersNested(index, item);
  }
  
  public HttpHeadersNested<A> editHttpHeader(int index) {
    if (httpHeaders.size() <= index) throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  
  public HttpHeadersNested<A> editFirstHttpHeader() {
    if (httpHeaders.size() == 0) throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(0, buildHttpHeader(0));
  }
  
  public HttpHeadersNested<A> editLastHttpHeader() {
    int index = httpHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  
  public HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<httpHeaders.size();i++) { 
    if (predicate.test(httpHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
    return setNewHttpHeaderLike(index, buildHttpHeader(index));
  }
  
  public String getPath() {
    return this.path;
  }
  
  public A withPath(String path) {
    this.path = path;
    return (A) this;
  }
  
  public boolean hasPath() {
    return this.path != null;
  }
  
  public Integer getPort() {
    return this.port;
  }
  
  public A withPort(Integer port) {
    this.port = port;
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public String getScheme() {
    return this.scheme;
  }
  
  public A withScheme(String scheme) {
    this.scheme = scheme;
    return (A) this;
  }
  
  public boolean hasScheme() {
    return this.scheme != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPHealthCheckConfigFluent that = (HTTPHealthCheckConfigFluent) o;
    if (!java.util.Objects.equals(host, that.host)) return false;
    if (!java.util.Objects.equals(httpHeaders, that.httpHeaders)) return false;
    if (!java.util.Objects.equals(path, that.path)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(scheme, that.scheme)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(host,  httpHeaders,  path,  port,  scheme,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (httpHeaders != null && !httpHeaders.isEmpty()) { sb.append("httpHeaders:"); sb.append(httpHeaders + ","); }
    if (path != null) { sb.append("path:"); sb.append(path + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class HttpHeadersNested<N> extends HTTPHeaderFluent<HttpHeadersNested<N>> implements Nested<N>{
    HttpHeadersNested(int index,HTTPHeader item) {
      this.index = index;
      this.builder = new HTTPHeaderBuilder(this, item);
    }
    HTTPHeaderBuilder builder;
    int index;
    
    public N and() {
      return (N) HTTPHealthCheckConfigFluent.this.setToHttpHeaders(index,builder.build());
    }
    
    public N endHttpHeader() {
      return and();
    }
    
  
  }

}