package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class WorkloadSelectorBuilder extends WorkloadSelectorFluent<WorkloadSelectorBuilder> implements VisitableBuilder<WorkloadSelector,WorkloadSelectorBuilder>{
  public WorkloadSelectorBuilder() {
    this(new WorkloadSelector());
  }
  
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent) {
    this(fluent, new WorkloadSelector());
  }
  
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent,WorkloadSelector instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public WorkloadSelectorBuilder(WorkloadSelector instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  WorkloadSelectorFluent<?> fluent;
  
  public WorkloadSelector build() {
    WorkloadSelector buildable = new WorkloadSelector(fluent.getLabels());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}