package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class VirtualServiceSpecBuilder extends VirtualServiceSpecFluent<VirtualServiceSpecBuilder> implements VisitableBuilder<VirtualServiceSpec,VirtualServiceSpecBuilder>{
  public VirtualServiceSpecBuilder() {
    this(new VirtualServiceSpec());
  }
  
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent) {
    this(fluent, new VirtualServiceSpec());
  }
  
  public VirtualServiceSpecBuilder(VirtualServiceSpecFluent<?> fluent,VirtualServiceSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public VirtualServiceSpecBuilder(VirtualServiceSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  VirtualServiceSpecFluent<?> fluent;
  
  public VirtualServiceSpec build() {
    VirtualServiceSpec buildable = new VirtualServiceSpec(fluent.getExportTo(),fluent.getGateways(),fluent.getHosts(),fluent.buildHttp(),fluent.buildTcp(),fluent.buildTls());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}