package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ReadinessProbeFluent<A extends ReadinessProbeFluent<A>> extends BaseFluent<A>{
  public ReadinessProbeFluent() {
  }
  
  public ReadinessProbeFluent(ReadinessProbe instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsReadinessProbeHealthCheckMethod,?> healthCheckMethod;
  private Integer failureThreshold;
  private Integer initialDelaySeconds;
  private Integer periodSeconds;
  private Integer successThreshold;
  private Integer timeoutSeconds;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ReadinessProbe instance) {
    instance = (instance != null ? instance : new ReadinessProbe());
    if (instance != null) {
          this.withHealthCheckMethod(instance.getHealthCheckMethod());
          this.withFailureThreshold(instance.getFailureThreshold());
          this.withInitialDelaySeconds(instance.getInitialDelaySeconds());
          this.withPeriodSeconds(instance.getPeriodSeconds());
          this.withSuccessThreshold(instance.getSuccessThreshold());
          this.withTimeoutSeconds(instance.getTimeoutSeconds());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsReadinessProbeHealthCheckMethod buildHealthCheckMethod() {
    return this.healthCheckMethod != null ? this.healthCheckMethod.build() : null;
  }
  
  public A withHealthCheckMethod(IsReadinessProbeHealthCheckMethod healthCheckMethod) {
    if (healthCheckMethod == null) {
        this.healthCheckMethod = null;
        this._visitables.remove("healthCheckMethod");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsReadinessProbeHealthCheckMethod,?> builder = builder(healthCheckMethod);;
        this._visitables.clear();
        this._visitables.get("healthCheckMethod").add(builder);
        this.healthCheckMethod = builder;
        return (A) this;
    }
  }
  
  public boolean hasHealthCheckMethod() {
    return this.healthCheckMethod != null;
  }
  
  public ReadinessProbeTcpSocketHealthCheckMethodNested<A> withNewReadinessProbeTcpSocketHealthCheckMethod() {
    return new ReadinessProbeTcpSocketHealthCheckMethodNested(null);
  }
  
  public ReadinessProbeTcpSocketHealthCheckMethodNested<A> withNewReadinessProbeTcpSocketHealthCheckMethodLike(ReadinessProbeTcpSocket item) {
    return new ReadinessProbeTcpSocketHealthCheckMethodNested(item);
  }
  
  public ReadinessProbeExecHealthCheckMethodNested<A> withNewReadinessProbeExecHealthCheckMethod() {
    return new ReadinessProbeExecHealthCheckMethodNested(null);
  }
  
  public ReadinessProbeExecHealthCheckMethodNested<A> withNewReadinessProbeExecHealthCheckMethodLike(ReadinessProbeExec item) {
    return new ReadinessProbeExecHealthCheckMethodNested(item);
  }
  
  public ReadinessProbeHttpGetHealthCheckMethodNested<A> withNewReadinessProbeHttpGetHealthCheckMethod() {
    return new ReadinessProbeHttpGetHealthCheckMethodNested(null);
  }
  
  public ReadinessProbeHttpGetHealthCheckMethodNested<A> withNewReadinessProbeHttpGetHealthCheckMethodLike(ReadinessProbeHttpGet item) {
    return new ReadinessProbeHttpGetHealthCheckMethodNested(item);
  }
  
  public Integer getFailureThreshold() {
    return this.failureThreshold;
  }
  
  public A withFailureThreshold(Integer failureThreshold) {
    this.failureThreshold = failureThreshold;
    return (A) this;
  }
  
  public boolean hasFailureThreshold() {
    return this.failureThreshold != null;
  }
  
  public Integer getInitialDelaySeconds() {
    return this.initialDelaySeconds;
  }
  
  public A withInitialDelaySeconds(Integer initialDelaySeconds) {
    this.initialDelaySeconds = initialDelaySeconds;
    return (A) this;
  }
  
  public boolean hasInitialDelaySeconds() {
    return this.initialDelaySeconds != null;
  }
  
  public Integer getPeriodSeconds() {
    return this.periodSeconds;
  }
  
  public A withPeriodSeconds(Integer periodSeconds) {
    this.periodSeconds = periodSeconds;
    return (A) this;
  }
  
  public boolean hasPeriodSeconds() {
    return this.periodSeconds != null;
  }
  
  public Integer getSuccessThreshold() {
    return this.successThreshold;
  }
  
  public A withSuccessThreshold(Integer successThreshold) {
    this.successThreshold = successThreshold;
    return (A) this;
  }
  
  public boolean hasSuccessThreshold() {
    return this.successThreshold != null;
  }
  
  public Integer getTimeoutSeconds() {
    return this.timeoutSeconds;
  }
  
  public A withTimeoutSeconds(Integer timeoutSeconds) {
    this.timeoutSeconds = timeoutSeconds;
    return (A) this;
  }
  
  public boolean hasTimeoutSeconds() {
    return this.timeoutSeconds != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ReadinessProbeFluent that = (ReadinessProbeFluent) o;
    if (!java.util.Objects.equals(healthCheckMethod, that.healthCheckMethod)) return false;
    if (!java.util.Objects.equals(failureThreshold, that.failureThreshold)) return false;
    if (!java.util.Objects.equals(initialDelaySeconds, that.initialDelaySeconds)) return false;
    if (!java.util.Objects.equals(periodSeconds, that.periodSeconds)) return false;
    if (!java.util.Objects.equals(successThreshold, that.successThreshold)) return false;
    if (!java.util.Objects.equals(timeoutSeconds, that.timeoutSeconds)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(healthCheckMethod,  failureThreshold,  initialDelaySeconds,  periodSeconds,  successThreshold,  timeoutSeconds,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (healthCheckMethod != null) { sb.append("healthCheckMethod:"); sb.append(healthCheckMethod + ","); }
    if (failureThreshold != null) { sb.append("failureThreshold:"); sb.append(failureThreshold + ","); }
    if (initialDelaySeconds != null) { sb.append("initialDelaySeconds:"); sb.append(initialDelaySeconds + ","); }
    if (periodSeconds != null) { sb.append("periodSeconds:"); sb.append(periodSeconds + ","); }
    if (successThreshold != null) { sb.append("successThreshold:"); sb.append(successThreshold + ","); }
    if (timeoutSeconds != null) { sb.append("timeoutSeconds:"); sb.append(timeoutSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1alpha3."+"ReadinessProbeTcpSocket": return (VisitableBuilder<T, ?>)new ReadinessProbeTcpSocketBuilder((ReadinessProbeTcpSocket) item);
    case "io.fabric8.istio.api.networking.v1alpha3."+"ReadinessProbeExec": return (VisitableBuilder<T, ?>)new ReadinessProbeExecBuilder((ReadinessProbeExec) item);
    case "io.fabric8.istio.api.networking.v1alpha3."+"ReadinessProbeHttpGet": return (VisitableBuilder<T, ?>)new ReadinessProbeHttpGetBuilder((ReadinessProbeHttpGet) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class ReadinessProbeTcpSocketHealthCheckMethodNested<N> extends ReadinessProbeTcpSocketFluent<ReadinessProbeTcpSocketHealthCheckMethodNested<N>> implements Nested<N>{
    ReadinessProbeTcpSocketHealthCheckMethodNested(ReadinessProbeTcpSocket item) {
      this.builder = new ReadinessProbeTcpSocketBuilder(this, item);
    }
    ReadinessProbeTcpSocketBuilder builder;
    
    public N and() {
      return (N) ReadinessProbeFluent.this.withHealthCheckMethod(builder.build());
    }
    
    public N endReadinessProbeTcpSocketHealthCheckMethod() {
      return and();
    }
    
  
  }
  public class ReadinessProbeExecHealthCheckMethodNested<N> extends ReadinessProbeExecFluent<ReadinessProbeExecHealthCheckMethodNested<N>> implements Nested<N>{
    ReadinessProbeExecHealthCheckMethodNested(ReadinessProbeExec item) {
      this.builder = new ReadinessProbeExecBuilder(this, item);
    }
    ReadinessProbeExecBuilder builder;
    
    public N and() {
      return (N) ReadinessProbeFluent.this.withHealthCheckMethod(builder.build());
    }
    
    public N endReadinessProbeExecHealthCheckMethod() {
      return and();
    }
    
  
  }
  public class ReadinessProbeHttpGetHealthCheckMethodNested<N> extends ReadinessProbeHttpGetFluent<ReadinessProbeHttpGetHealthCheckMethodNested<N>> implements Nested<N>{
    ReadinessProbeHttpGetHealthCheckMethodNested(ReadinessProbeHttpGet item) {
      this.builder = new ReadinessProbeHttpGetBuilder(this, item);
    }
    ReadinessProbeHttpGetBuilder builder;
    
    public N and() {
      return (N) ReadinessProbeFluent.this.withHealthCheckMethod(builder.build());
    }
    
    public N endReadinessProbeHttpGetHealthCheckMethod() {
      return and();
    }
    
  
  }

}