package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRouteDestinationFluent<A extends HTTPRouteDestinationFluent<A>> extends BaseFluent<A>{
  public HTTPRouteDestinationFluent() {
  }
  
  public HTTPRouteDestinationFluent(HTTPRouteDestination instance) {
    this.copyInstance(instance);
  }
  private DestinationBuilder destination;
  private HeadersBuilder headers;
  private Integer weight;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRouteDestination instance) {
    instance = (instance != null ? instance : new HTTPRouteDestination());
    if (instance != null) {
          this.withDestination(instance.getDestination());
          this.withHeaders(instance.getHeaders());
          this.withWeight(instance.getWeight());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Destination buildDestination() {
    return this.destination != null ? this.destination.build() : null;
  }
  
  public A withDestination(Destination destination) {
    this._visitables.remove("destination");
    if (destination != null) {
        this.destination = new DestinationBuilder(destination);
        this._visitables.get("destination").add(this.destination);
    } else {
        this.destination = null;
        this._visitables.get("destination").remove(this.destination);
    }
    return (A) this;
  }
  
  public boolean hasDestination() {
    return this.destination != null;
  }
  
  public DestinationNested<A> withNewDestination() {
    return new DestinationNested(null);
  }
  
  public DestinationNested<A> withNewDestinationLike(Destination item) {
    return new DestinationNested(item);
  }
  
  public DestinationNested<A> editDestination() {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(null));
  }
  
  public DestinationNested<A> editOrNewDestination() {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(new DestinationBuilder().build()));
  }
  
  public DestinationNested<A> editOrNewDestinationLike(Destination item) {
    return withNewDestinationLike(java.util.Optional.ofNullable(buildDestination()).orElse(item));
  }
  
  public Headers buildHeaders() {
    return this.headers != null ? this.headers.build() : null;
  }
  
  public A withHeaders(Headers headers) {
    this._visitables.remove("headers");
    if (headers != null) {
        this.headers = new HeadersBuilder(headers);
        this._visitables.get("headers").add(this.headers);
    } else {
        this.headers = null;
        this._visitables.get("headers").remove(this.headers);
    }
    return (A) this;
  }
  
  public boolean hasHeaders() {
    return this.headers != null;
  }
  
  public HeadersNested<A> withNewHeaders() {
    return new HeadersNested(null);
  }
  
  public HeadersNested<A> withNewHeadersLike(Headers item) {
    return new HeadersNested(item);
  }
  
  public HeadersNested<A> editHeaders() {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(null));
  }
  
  public HeadersNested<A> editOrNewHeaders() {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(new HeadersBuilder().build()));
  }
  
  public HeadersNested<A> editOrNewHeadersLike(Headers item) {
    return withNewHeadersLike(java.util.Optional.ofNullable(buildHeaders()).orElse(item));
  }
  
  public Integer getWeight() {
    return this.weight;
  }
  
  public A withWeight(Integer weight) {
    this.weight = weight;
    return (A) this;
  }
  
  public boolean hasWeight() {
    return this.weight != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRouteDestinationFluent that = (HTTPRouteDestinationFluent) o;
    if (!java.util.Objects.equals(destination, that.destination)) return false;
    if (!java.util.Objects.equals(headers, that.headers)) return false;
    if (!java.util.Objects.equals(weight, that.weight)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(destination,  headers,  weight,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (destination != null) { sb.append("destination:"); sb.append(destination + ","); }
    if (headers != null) { sb.append("headers:"); sb.append(headers + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class DestinationNested<N> extends DestinationFluent<DestinationNested<N>> implements Nested<N>{
    DestinationNested(Destination item) {
      this.builder = new DestinationBuilder(this, item);
    }
    DestinationBuilder builder;
    
    public N and() {
      return (N) HTTPRouteDestinationFluent.this.withDestination(builder.build());
    }
    
    public N endDestination() {
      return and();
    }
    
  
  }
  public class HeadersNested<N> extends HeadersFluent<HeadersNested<N>> implements Nested<N>{
    HeadersNested(Headers item) {
      this.builder = new HeadersBuilder(this, item);
    }
    HeadersBuilder builder;
    
    public N and() {
      return (N) HTTPRouteDestinationFluent.this.withHeaders(builder.build());
    }
    
    public N endHeaders() {
      return and();
    }
    
  
  }

}