package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRedirectFluent<A extends HTTPRedirectFluent<A>> extends BaseFluent<A>{
  public HTTPRedirectFluent() {
  }
  
  public HTTPRedirectFluent(HTTPRedirect instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsHTTPRedirectRedirectPort,?> redirectPort;
  private String authority;
  private Integer redirectCode;
  private String scheme;
  private String uri;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRedirect instance) {
    instance = (instance != null ? instance : new HTTPRedirect());
    if (instance != null) {
          this.withRedirectPort(instance.getRedirectPort());
          this.withAuthority(instance.getAuthority());
          this.withRedirectCode(instance.getRedirectCode());
          this.withScheme(instance.getScheme());
          this.withUri(instance.getUri());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsHTTPRedirectRedirectPort buildRedirectPort() {
    return this.redirectPort != null ? this.redirectPort.build() : null;
  }
  
  public A withRedirectPort(IsHTTPRedirectRedirectPort redirectPort) {
    if (redirectPort == null) {
        this.redirectPort = null;
        this._visitables.remove("redirectPort");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsHTTPRedirectRedirectPort,?> builder = builder(redirectPort);;
        this._visitables.clear();
        this._visitables.get("redirectPort").add(builder);
        this.redirectPort = builder;
        return (A) this;
    }
  }
  
  public boolean hasRedirectPort() {
    return this.redirectPort != null;
  }
  
  public HTTPRedirectPortNested<A> withNewHTTPRedirectPort() {
    return new HTTPRedirectPortNested(null);
  }
  
  public HTTPRedirectPortNested<A> withNewHTTPRedirectPortLike(HTTPRedirectPort item) {
    return new HTTPRedirectPortNested(item);
  }
  
  public A withNewHTTPRedirectPort(Integer port) {
    return (A)withRedirectPort(new HTTPRedirectPort(port));
  }
  
  public HTTPRedirectDerivePortNested<A> withNewHTTPRedirectDerivePort() {
    return new HTTPRedirectDerivePortNested(null);
  }
  
  public HTTPRedirectDerivePortNested<A> withNewHTTPRedirectDerivePortLike(HTTPRedirectDerivePort item) {
    return new HTTPRedirectDerivePortNested(item);
  }
  
  public String getAuthority() {
    return this.authority;
  }
  
  public A withAuthority(String authority) {
    this.authority = authority;
    return (A) this;
  }
  
  public boolean hasAuthority() {
    return this.authority != null;
  }
  
  public Integer getRedirectCode() {
    return this.redirectCode;
  }
  
  public A withRedirectCode(Integer redirectCode) {
    this.redirectCode = redirectCode;
    return (A) this;
  }
  
  public boolean hasRedirectCode() {
    return this.redirectCode != null;
  }
  
  public String getScheme() {
    return this.scheme;
  }
  
  public A withScheme(String scheme) {
    this.scheme = scheme;
    return (A) this;
  }
  
  public boolean hasScheme() {
    return this.scheme != null;
  }
  
  public String getUri() {
    return this.uri;
  }
  
  public A withUri(String uri) {
    this.uri = uri;
    return (A) this;
  }
  
  public boolean hasUri() {
    return this.uri != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRedirectFluent that = (HTTPRedirectFluent) o;
    if (!java.util.Objects.equals(redirectPort, that.redirectPort)) return false;
    if (!java.util.Objects.equals(authority, that.authority)) return false;
    if (!java.util.Objects.equals(redirectCode, that.redirectCode)) return false;
    if (!java.util.Objects.equals(scheme, that.scheme)) return false;
    if (!java.util.Objects.equals(uri, that.uri)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(redirectPort,  authority,  redirectCode,  scheme,  uri,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (redirectPort != null) { sb.append("redirectPort:"); sb.append(redirectPort + ","); }
    if (authority != null) { sb.append("authority:"); sb.append(authority + ","); }
    if (redirectCode != null) { sb.append("redirectCode:"); sb.append(redirectCode + ","); }
    if (scheme != null) { sb.append("scheme:"); sb.append(scheme + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1alpha3."+"HTTPRedirectPort": return (VisitableBuilder<T, ?>)new HTTPRedirectPortBuilder((HTTPRedirectPort) item);
    case "io.fabric8.istio.api.networking.v1alpha3."+"HTTPRedirectDerivePort": return (VisitableBuilder<T, ?>)new HTTPRedirectDerivePortBuilder((HTTPRedirectDerivePort) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class HTTPRedirectPortNested<N> extends HTTPRedirectPortFluent<HTTPRedirectPortNested<N>> implements Nested<N>{
    HTTPRedirectPortNested(HTTPRedirectPort item) {
      this.builder = new HTTPRedirectPortBuilder(this, item);
    }
    HTTPRedirectPortBuilder builder;
    
    public N and() {
      return (N) HTTPRedirectFluent.this.withRedirectPort(builder.build());
    }
    
    public N endHTTPRedirectPort() {
      return and();
    }
    
  
  }
  public class HTTPRedirectDerivePortNested<N> extends HTTPRedirectDerivePortFluent<HTTPRedirectDerivePortNested<N>> implements Nested<N>{
    HTTPRedirectDerivePortNested(HTTPRedirectDerivePort item) {
      this.builder = new HTTPRedirectDerivePortBuilder(this, item);
    }
    HTTPRedirectDerivePortBuilder builder;
    
    public N and() {
      return (N) HTTPRedirectFluent.this.withRedirectPort(builder.build());
    }
    
    public N endHTTPRedirectDerivePort() {
      return and();
    }
    
  
  }

}