package io.fabric8.istio.api.meta.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class IstioConditionBuilder extends IstioConditionFluent<IstioConditionBuilder> implements VisitableBuilder<IstioCondition,IstioConditionBuilder>{
  public IstioConditionBuilder() {
    this(new IstioCondition());
  }
  
  public IstioConditionBuilder(IstioConditionFluent<?> fluent) {
    this(fluent, new IstioCondition());
  }
  
  public IstioConditionBuilder(IstioConditionFluent<?> fluent,IstioCondition instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public IstioConditionBuilder(IstioCondition instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  IstioConditionFluent<?> fluent;
  
  public IstioCondition build() {
    IstioCondition buildable = new IstioCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}