package io.fabric8.istio.api.networking.v1alpha3;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class EnvoyFilterPatchFluent<A extends EnvoyFilterPatchFluent<A>> extends BaseFluent<A>{
  public EnvoyFilterPatchFluent() {
  }
  
  public EnvoyFilterPatchFluent(EnvoyFilterPatch instance) {
    this.copyInstance(instance);
  }
  private EnvoyFilterPatchFilterClass filterClass;
  private EnvoyFilterPatchOperation operation;
  private Map<String,Object> value;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(EnvoyFilterPatch instance) {
    instance = (instance != null ? instance : new EnvoyFilterPatch());
    if (instance != null) {
          this.withFilterClass(instance.getFilterClass());
          this.withOperation(instance.getOperation());
          this.withValue(instance.getValue());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public EnvoyFilterPatchFilterClass getFilterClass() {
    return this.filterClass;
  }
  
  public A withFilterClass(EnvoyFilterPatchFilterClass filterClass) {
    this.filterClass = filterClass;
    return (A) this;
  }
  
  public boolean hasFilterClass() {
    return this.filterClass != null;
  }
  
  public EnvoyFilterPatchOperation getOperation() {
    return this.operation;
  }
  
  public A withOperation(EnvoyFilterPatchOperation operation) {
    this.operation = operation;
    return (A) this;
  }
  
  public boolean hasOperation() {
    return this.operation != null;
  }
  
  public A addToValue(String key,Object value) {
    if(this.value == null && key != null && value != null) { this.value = new LinkedHashMap(); }
    if(key != null && value != null) {this.value.put(key, value);} return (A)this;
  }
  
  public A addToValue(Map<String,Object> map) {
    if(this.value == null && map != null) { this.value = new LinkedHashMap(); }
    if(map != null) { this.value.putAll(map);} return (A)this;
  }
  
  public A removeFromValue(String key) {
    if(this.value == null) { return (A) this; }
    if(key != null && this.value != null) {this.value.remove(key);} return (A)this;
  }
  
  public A removeFromValue(Map<String,Object> map) {
    if(this.value == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.value != null){this.value.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getValue() {
    return this.value;
  }
  
  public <K,V>A withValue(Map<String,Object> value) {
    if (value == null) {
      this.value = null;
    } else {
      this.value = new LinkedHashMap(value);
    }
    return (A) this;
  }
  
  public boolean hasValue() {
    return this.value != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    EnvoyFilterPatchFluent that = (EnvoyFilterPatchFluent) o;
    if (!java.util.Objects.equals(filterClass, that.filterClass)) return false;
    if (!java.util.Objects.equals(operation, that.operation)) return false;
    if (!java.util.Objects.equals(value, that.value)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(filterClass,  operation,  value,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (filterClass != null) { sb.append("filterClass:"); sb.append(filterClass + ","); }
    if (operation != null) { sb.append("operation:"); sb.append(operation + ","); }
    if (value != null && !value.isEmpty()) { sb.append("value:"); sb.append(value + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}