package io.fabric8.istio.api.analysis.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class AnalysisMessageBaseFluent<A extends AnalysisMessageBaseFluent<A>> extends BaseFluent<A>{
  public AnalysisMessageBaseFluent() {
  }
  
  public AnalysisMessageBaseFluent(AnalysisMessageBase instance) {
    this.copyInstance(instance);
  }
  private String documentationUrl;
  private AnalysisMessageBaseLevel level;
  private AnalysisMessageBaseTypeBuilder type;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(AnalysisMessageBase instance) {
    instance = (instance != null ? instance : new AnalysisMessageBase());
    if (instance != null) {
          this.withDocumentationUrl(instance.getDocumentationUrl());
          this.withLevel(instance.getLevel());
          this.withType(instance.getType());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getDocumentationUrl() {
    return this.documentationUrl;
  }
  
  public A withDocumentationUrl(String documentationUrl) {
    this.documentationUrl = documentationUrl;
    return (A) this;
  }
  
  public boolean hasDocumentationUrl() {
    return this.documentationUrl != null;
  }
  
  public AnalysisMessageBaseLevel getLevel() {
    return this.level;
  }
  
  public A withLevel(AnalysisMessageBaseLevel level) {
    this.level = level;
    return (A) this;
  }
  
  public boolean hasLevel() {
    return this.level != null;
  }
  
  public AnalysisMessageBaseType buildType() {
    return this.type != null ? this.type.build() : null;
  }
  
  public A withType(AnalysisMessageBaseType type) {
    this._visitables.remove("type");
    if (type != null) {
        this.type = new AnalysisMessageBaseTypeBuilder(type);
        this._visitables.get("type").add(this.type);
    } else {
        this.type = null;
        this._visitables.get("type").remove(this.type);
    }
    return (A) this;
  }
  
  public boolean hasType() {
    return this.type != null;
  }
  
  public A withNewType(String code,String name) {
    return (A)withType(new AnalysisMessageBaseType(code, name));
  }
  
  public TypeNested<A> withNewType() {
    return new TypeNested(null);
  }
  
  public TypeNested<A> withNewTypeLike(AnalysisMessageBaseType item) {
    return new TypeNested(item);
  }
  
  public TypeNested<A> editType() {
    return withNewTypeLike(java.util.Optional.ofNullable(buildType()).orElse(null));
  }
  
  public TypeNested<A> editOrNewType() {
    return withNewTypeLike(java.util.Optional.ofNullable(buildType()).orElse(new AnalysisMessageBaseTypeBuilder().build()));
  }
  
  public TypeNested<A> editOrNewTypeLike(AnalysisMessageBaseType item) {
    return withNewTypeLike(java.util.Optional.ofNullable(buildType()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AnalysisMessageBaseFluent that = (AnalysisMessageBaseFluent) o;
    if (!java.util.Objects.equals(documentationUrl, that.documentationUrl)) return false;
    if (!java.util.Objects.equals(level, that.level)) return false;
    if (!java.util.Objects.equals(type, that.type)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(documentationUrl,  level,  type,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (documentationUrl != null) { sb.append("documentationUrl:"); sb.append(documentationUrl + ","); }
    if (level != null) { sb.append("level:"); sb.append(level + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TypeNested<N> extends AnalysisMessageBaseTypeFluent<TypeNested<N>> implements Nested<N>{
    TypeNested(AnalysisMessageBaseType item) {
      this.builder = new AnalysisMessageBaseTypeBuilder(this, item);
    }
    AnalysisMessageBaseTypeBuilder builder;
    
    public N and() {
      return (N) AnalysisMessageBaseFluent.this.withType(builder.build());
    }
    
    public N endType() {
      return and();
    }
    
  
  }

}