package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ReadinessProbeBuilder extends ReadinessProbeFluentImpl<ReadinessProbeBuilder> implements VisitableBuilder<ReadinessProbe,ReadinessProbeBuilder>{
  public ReadinessProbeBuilder() {
    this(false);
  }
  public ReadinessProbeBuilder(Boolean validationEnabled) {
    this(new ReadinessProbe(), validationEnabled);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent) {
    this(fluent, false);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ReadinessProbe(), validationEnabled);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,ReadinessProbe instance) {
    this(fluent, instance, false);
  }
  public ReadinessProbeBuilder(ReadinessProbeFluent<?> fluent,ReadinessProbe instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withHealthCheckMethod(instance.getHealthCheckMethod()); 
    fluent.withFailureThreshold(instance.getFailureThreshold()); 
    fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    fluent.withPeriodSeconds(instance.getPeriodSeconds()); 
    fluent.withSuccessThreshold(instance.getSuccessThreshold()); 
    fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.validationEnabled = validationEnabled; 
  }
  public ReadinessProbeBuilder(ReadinessProbe instance) {
    this(instance,false);
  }
  public ReadinessProbeBuilder(ReadinessProbe instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withHealthCheckMethod(instance.getHealthCheckMethod()); 
    this.withFailureThreshold(instance.getFailureThreshold()); 
    this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); 
    this.withPeriodSeconds(instance.getPeriodSeconds()); 
    this.withSuccessThreshold(instance.getSuccessThreshold()); 
    this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
    this.validationEnabled = validationEnabled; 
  }
  ReadinessProbeFluent<?> fluent;
  Boolean validationEnabled;
  public ReadinessProbe build() {
    ReadinessProbe buildable = new ReadinessProbe(fluent.getHealthCheckMethod(),fluent.getFailureThreshold(),fluent.getInitialDelaySeconds(),fluent.getPeriodSeconds(),fluent.getSuccessThreshold(),fluent.getTimeoutSeconds());
    return buildable;
  }
  
}