package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OutboundTrafficPolicyBuilder extends OutboundTrafficPolicyFluentImpl<OutboundTrafficPolicyBuilder> implements VisitableBuilder<OutboundTrafficPolicy,OutboundTrafficPolicyBuilder>{
  public OutboundTrafficPolicyBuilder() {
    this(false);
  }
  public OutboundTrafficPolicyBuilder(Boolean validationEnabled) {
    this(new OutboundTrafficPolicy(), validationEnabled);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OutboundTrafficPolicy(), validationEnabled);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance) {
    this(fluent, instance, false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicyFluent<?> fluent,OutboundTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEgressProxy(instance.getEgressProxy()); 
    fluent.withMode(instance.getMode()); 
    this.validationEnabled = validationEnabled; 
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance) {
    this(instance,false);
  }
  public OutboundTrafficPolicyBuilder(OutboundTrafficPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEgressProxy(instance.getEgressProxy()); 
    this.withMode(instance.getMode()); 
    this.validationEnabled = validationEnabled; 
  }
  OutboundTrafficPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public OutboundTrafficPolicy build() {
    OutboundTrafficPolicy buildable = new OutboundTrafficPolicy(fluent.getEgressProxy(),fluent.getMode());
    return buildable;
  }
  
}