package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SidecarSpecBuilder extends SidecarSpecFluentImpl<SidecarSpecBuilder> implements VisitableBuilder<SidecarSpec,SidecarSpecBuilder>{
  public SidecarSpecBuilder() {
    this(false);
  }
  public SidecarSpecBuilder(Boolean validationEnabled) {
    this(new SidecarSpec(), validationEnabled);
  }
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SidecarSpec(), validationEnabled);
  }
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,SidecarSpec instance) {
    this(fluent, instance, false);
  }
  public SidecarSpecBuilder(SidecarSpecFluent<?> fluent,SidecarSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withEgress(instance.getEgress()); 
    fluent.withIngress(instance.getIngress()); 
    fluent.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
    fluent.withWorkloadSelector(instance.getWorkloadSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public SidecarSpecBuilder(SidecarSpec instance) {
    this(instance,false);
  }
  public SidecarSpecBuilder(SidecarSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withEgress(instance.getEgress()); 
    this.withIngress(instance.getIngress()); 
    this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy()); 
    this.withWorkloadSelector(instance.getWorkloadSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  SidecarSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SidecarSpec build() {
    SidecarSpec buildable = new SidecarSpec(fluent.getEgress(),fluent.getIngress(),fluent.getOutboundTrafficPolicy(),fluent.getWorkloadSelector());
    return buildable;
  }
  
}