package io.fabric8.istio.api.networking.v1alpha3;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class ClientTLSSettingsBuilder extends io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluentImpl<io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings,io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsBuilder>{
  public ClientTLSSettingsBuilder() {
    this(false);
  }
  public ClientTLSSettingsBuilder(java.lang.Boolean validationEnabled) {
    this(new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ClientTLSSettings(), validationEnabled);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings instance) {
    this(fluent, instance, false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent<?> fluent,io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCaCertificates(instance.getCaCertificates()); 
    fluent.withClientCertificate(instance.getClientCertificate()); 
    fluent.withCredentialName(instance.getCredentialName()); 
    fluent.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    fluent.withMode(instance.getMode()); 
    fluent.withPrivateKey(instance.getPrivateKey()); 
    fluent.withSni(instance.getSni()); 
    fluent.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings instance) {
    this(instance,false);
  }
  public ClientTLSSettingsBuilder(io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCaCertificates(instance.getCaCertificates()); 
    this.withClientCertificate(instance.getClientCertificate()); 
    this.withCredentialName(instance.getCredentialName()); 
    this.withInsecureSkipVerify(instance.getInsecureSkipVerify()); 
    this.withMode(instance.getMode()); 
    this.withPrivateKey(instance.getPrivateKey()); 
    this.withSni(instance.getSni()); 
    this.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettingsFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.networking.v1alpha3.ClientTLSSettings build() {
    ClientTLSSettings buildable = new ClientTLSSettings(fluent.getCaCertificates(),fluent.getClientCertificate(),fluent.getCredentialName(),fluent.getInsecureSkipVerify(),fluent.getMode(),fluent.getPrivateKey(),fluent.getSni(),fluent.getSubjectAltNames());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ClientTLSSettingsBuilder that = (ClientTLSSettingsBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}